#pragma once

#include "file_player_session.h"

#include <yandex_io/capabilities/file_player/interfaces/i_file_player_capability.h>
#include <yandex_io/libs/activity_tracker/activity_tracker.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/threading/i_callback_queue.h>
#include <yandex_io/sdk/interfaces/directive.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/sdk/private/remoting/i_remote_object.h>
#include <yandex_io/sdk/private/remoting/i_remoting_registry.h>
#include <yandex_io/services/aliced/directive_processor/interface/i_directive_processor.h>

#include <util/folder/path.h>

#include <unordered_map>

namespace quasar {
    class FilePlayerCapability
        : public YandexIO::IDirectiveHandler,
          public YandexIO::IFilePlayerCapability,
          public YandexIO::IRemoteObject,
          public std::enable_shared_from_this<FilePlayerCapability> {
    public:
        FilePlayerCapability(
            std::shared_ptr<quasar::ICallbackQueue> worker,
            std::shared_ptr<YandexIO::IDevice> device,
            YandexIO::ActivityTracker& activityTracker,
            YandexIO::IDirectiveProcessorWeakPtr directiveProcessor,
            const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory,
            std::weak_ptr<YandexIO::IRemotingRegistry> remotingRegistry);

        ~FilePlayerCapability();

        void init();

        /// IFilePlayerCapability implementation
        void playSoundFile(const std::string& fileName,
                           std::optional<quasar::proto::AudioChannel> channel,
                           std::optional<PlayParams> params = std::nullopt,
                           std::shared_ptr<YandexIO::IPlaySoundFileListener> listener = nullptr) override;
        void stopSoundFile(const std::string& fileName) override;

        /// IDirectiveHandler implementation
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void cancelDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void prefetchDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;

        /// IRemoteObject implementation
        void handleRemotingMessage(const quasar::proto::Remoting& message,
                                   std::shared_ptr<YandexIO::IRemotingConnection> connection) override;

        void onAudioClientMessage(const quasar::ipc::SharedMessage& message);

    private:
        void completeDirective(const std::shared_ptr<YandexIO::Directive>& directive);
        void onQuasarMessage(
            const std::shared_ptr<YandexIO::Directive>& directive,
            const std::shared_ptr<FilePlayerSession>& session,
            const ipc::SharedMessage& sharedMessage);

        void handleOnStartedCallback(const std::shared_ptr<YandexIO::Directive>& directive);
        void handleOnCompletedCallback(const std::shared_ptr<YandexIO::Directive>& directive);

        static void sendStartedEvent(const std::string& requestId, std::shared_ptr<YandexIO::IRemotingConnection> connection);
        static void sendCompletedEvent(const std::string& requestId, std::shared_ptr<YandexIO::IRemotingConnection> connection);

    private:
        YandexIO::ActivityTracker& activityTracker_;
        const YandexIO::IDirectiveProcessorWeakPtr directiveProcessor_;

        std::unordered_map<std::shared_ptr<YandexIO::Directive>, std::shared_ptr<FilePlayerSession>> sessionByDirective_;
        std::unordered_map<std::shared_ptr<YandexIO::Directive>, std::shared_ptr<YandexIO::IPlaySoundFileListener>> listenerByDirective_;

        bool isReady_ = false;
        struct QueuedMessage {
            quasar::proto::Remoting message;
            std::shared_ptr<YandexIO::IRemotingConnection> connection;
        };
        std::queue<QueuedMessage> queuedMessages_;

        const TFsPath fileStoragePath_;
        const std::shared_ptr<quasar::ICallbackQueue> worker_;
        const std::shared_ptr<ipc::IConnector> audioClientConnector_;
    };

} // namespace quasar
