#include "file_player_session.h"

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/libs/json_utils/json_utils.h>

using namespace YandexIO;
using namespace quasar;

FilePlayerSession::FilePlayerSession(const std::string& fileName,
                                     const TFsPath& filePath,
                                     std::optional<quasar::proto::AudioChannel> channel,
                                     IFilePlayerCapability::PlayParams params)
    : fileName_(fileName)
    , audioChannel_(channel.value_or(proto::CONTENT_CHANNEL))
    , descriptor_(createDescriptor(channel))
    , playLooped_(params.playLooped)
    , playTimes_(params.playTimes)
{
    playRequest_.mutable_player_descriptor()->CopyFrom(descriptor_);
    playRequest_.mutable_play_audio()->set_format(proto::Audio::AUDIO_FILE);
    playRequest_.mutable_play_audio()->set_set_pause(false);
    playRequest_.mutable_play_audio()->set_file_path(filePath.GetPath());
    playRequest_.mutable_play_audio()->set_report_metrics(false);

    cleanRequest_.mutable_player_descriptor()->CopyFrom(descriptor_);
    cleanRequest_.mutable_clean_players();

    replayRequest_.mutable_player_descriptor()->CopyFrom(descriptor_);
    replayRequest_.mutable_replay();
}

uint32_t FilePlayerSession::getPlayedCount() const {
    return alreadyPlayedCount_;
}

bool FilePlayerSession::onFilePlayFinished()
{
    alreadyPlayedCount_++;
    return playLooped_ || playTimes_ > alreadyPlayedCount_;
}

const std::string& FilePlayerSession::getFileName() const {
    return fileName_;
}

const proto::AudioPlayerDescriptor& FilePlayerSession::getDescriptor() const {
    return descriptor_;
}

const proto::MediaRequest& FilePlayerSession::getPlayRequest() const {
    return playRequest_;
}

const proto::MediaRequest& FilePlayerSession::getCleanRequest() const {
    return cleanRequest_;
}

const proto::MediaRequest& FilePlayerSession::getReplayRequest() const {
    return replayRequest_;
}

std::string FilePlayerSession::activityName() const {
    return "FilePlayerSession";
}

void FilePlayerSession::setBackground() {
    // do nothing
}

void FilePlayerSession::setForeground() {
    // do nothing
}

proto::AudioChannel FilePlayerSession::getAudioChannel() const {
    return audioChannel_;
}

bool FilePlayerSession::isLocal() const {
    return true;
}

proto::AudioPlayerDescriptor FilePlayerSession::createDescriptor(std::optional<quasar::proto::AudioChannel> channel)
{
    proto::AudioPlayerDescriptor descriptor;
    descriptor.set_player_id(makeUUID());
    descriptor.set_type(proto::AudioPlayerDescriptor::FILE_PLAYER);
    if (channel.has_value()) {
        descriptor.set_audio_channel(channel.value());
    }

    return descriptor;
}
