#pragma once

#include <yandex_io/capabilities/file_player/interfaces/i_file_player_capability.h>
#include <yandex_io/libs/activity_tracker/interface/i_activity.h>
#include <yandex_io/libs/ipc/message.h>
#include <yandex_io/sdk/interfaces/directive.h>

#include <util/folder/path.h>

namespace quasar {
    class FilePlayerSession
        : public YandexIO::IActivity {
    public:
        using SharedPtr = std::shared_ptr<FilePlayerSession>;

        FilePlayerSession(const std::string& fileName,
                          const TFsPath& filePath,
                          std::optional<quasar::proto::AudioChannel> channel,
                          YandexIO::IFilePlayerCapability::PlayParams params);

        const proto::MediaRequest& getPlayRequest() const;
        const proto::MediaRequest& getCleanRequest() const;
        const proto::MediaRequest& getReplayRequest() const;

        const std::string& getFileName() const;
        const proto::AudioPlayerDescriptor& getDescriptor() const;

        /**
         * Call this method after playing file is finished
         * @return is one more rewind required
         */
        bool onFilePlayFinished();

        /**
         * @return how many times file has already been played
         */
        uint32_t getPlayedCount() const;

        /// IActivity implementation
        std::string activityName() const override;
        void setBackground() override;
        void setForeground() override;
        proto::AudioChannel getAudioChannel() const override;
        bool isLocal() const override;

    private:
        static proto::AudioPlayerDescriptor createDescriptor(std::optional<quasar::proto::AudioChannel> channel);

    private:
        const std::string fileName_;
        const proto::AudioChannel audioChannel_;
        const proto::AudioPlayerDescriptor descriptor_;

        const bool playLooped_;
        const uint32_t playTimes_;
        uint32_t alreadyPlayedCount_ = 0;

        proto::MediaRequest playRequest_;
        proto::MediaRequest cleanRequest_;
        proto::MediaRequest replayRequest_;
    };

} // namespace quasar
