#pragma once

#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/sdk/private/device_context.h>

namespace quasar {

    class LegacyIotCapability
        : public YandexIO::IDirectiveHandler {
    public:
        LegacyIotCapability(std::shared_ptr<ipc::IConnector> toIot);

        // IDirectiveHandler implementation
        //
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void cancelDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void prefetchDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;

    private:
        void handleIotDiscoveryStart(const Json::Value& payload);
        void handleIotDiscoveryStop(const Json::Value& payload);
        void handleIotDiscoveryCredentials(const Json::Value& payload);

        static proto::IotDiscoveryResult::ResultCode parseDiscoveryResultCode(const std::string& code);

    private:
        std::shared_ptr<ipc::IConnector> toIot_;
    };

} // namespace quasar
