#pragma once

#include "url_rewriter.h"

#include <yandex_io/capabilities/device_state/interfaces/i_device_state_capability.h>
#include <yandex_io/services/aliced/device_state/alice_device_state.h>
#include <yandex_io/services/aliced/directive_processor/interface/i_directive_processor.h>

#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/threading/i_callback_queue.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/sdk/private/device_context.h>

#include <unordered_map>

namespace YandexIO {

    class LegacyPlayerCapability
        : public IDirectiveHandler {
    public:
        LegacyPlayerCapability(
            IDirectiveProcessorWeakPtr directiveProcessor,
            quasar::AliceDeviceState& aliceDeviceState,
            std::shared_ptr<IDevice> device,
            DeviceContext& deviceContext,
            std::shared_ptr<quasar::ipc::IConnector> toMedia,
            std::shared_ptr<quasar::ipc::IConnector> toInterface,
            std::shared_ptr<IDeviceStateCapability> deviceStateCapability);

        void handleMediadMessage(const quasar::ipc::SharedMessage& sharedMessage);
        void onUserConfig(const quasar::proto::UserConfig& userConfig);
        void onInterfacedMessage(const quasar::ipc::SharedMessage& sharedMessage);

        // IDirectiveHandler implementation
        //
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<Directive>& directive) override;
        void cancelDirective(const std::shared_ptr<Directive>& directive) override;
        void prefetchDirective(const std::shared_ptr<Directive>& directive) override;

    private:
        bool isCurrentScreenSuitable() const;
        void handleMusicPlay(const std::shared_ptr<Directive>& directive);
        void handleRadioPlay(const std::shared_ptr<Directive>& directive);
        void handlePlayerPause(const Json::Value& payload, const std::string& vinsRequestId);
        void handlePlayerContinue(const Json::Value& payload, const std::string& vinsRequestId);
        void handlePlayerNextTrack(const std::string& vinsRequestId, const Json::Value& payload);
        void handlePlayerPreviousTrack(const std::string& vinsRequestId, const Json::Value& payload);
        void handlePlayerReplay(const std::string& vinsRequestId);
        void handlePlayerLike(const std::string& vinsRequestId);
        void handlePlayerDislike(const std::string& vinsRequestId);
        void handlePlayerRewind(const Json::Value& payload, const std::string& vinsRequestId);
        void onLegacyPlayerStateChanged(const quasar::proto::LegacyPlayerStateChanged& stateChanged);

    private:
        const IDirectiveProcessorWeakPtr directiveProcessor_;
        quasar::AliceDeviceState& aliceDeviceState_;
        const std::shared_ptr<IDevice> device_;

        std::shared_ptr<Directive> musicPlayDirective_;
        std::shared_ptr<Directive> radioPlayDirective_;

        const std::shared_ptr<quasar::ipc::IConnector> toMedia_;
        const std::shared_ptr<quasar::ipc::IConnector> toInterface_;

        quasar::UrlRewriter radioUrlRewriter_;
        bool hasScreens_ = false;
        bool hasJavaRadio_ = false;
        int64_t javaRadioPlayTs_ = 0;
        Json::Value mediadState_;
        DeviceContext& deviceContext_;
        std::shared_ptr<IDeviceStateCapability> deviceStateCapability_;
        bool lastPlayIsMusic_ = false;
    };

} // namespace YandexIO
