#pragma once

#include <json/json.h>

#include <regex>
#include <string>
#include <vector>

namespace quasar {

    class UrlRewriter {
    public:
        UrlRewriter() = default;
        explicit UrlRewriter(const Json::Value& arrayOfRules);

        void updateRules(const Json::Value& arrayOfRules) noexcept;

        std::string rewriteUrl(std::string originUrl, bool verbose = false) const noexcept;

    private:
        struct Rule {
            std::string text;
            std::regex regex;
            std::string replacement;
            bool next{false};
        };
        std::vector<Rule> rules_;
    };

} // namespace quasar
