#pragma once

#include <yandex_io/interfaces/glagol/i_glagol_cluster_provider.h>
#include <yandex_io/interfaces/multiroom/i_multiroom_provider.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/libs/device/i_device.h>

namespace quasar {

    // ** NOTE ** MRForwarderCapability acts as a dummy directive marshaling to other
    //            devices. In the future, it should be deleted and replaced with an honest
    //            IEndpoint on our side and with the correct filling of the endpoint_id
    //            field on the server side
    class MRForwarderCapability: public YandexIO::IDirectiveHandler {
    public:
        MRForwarderCapability(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<IGlagolClusterProvider> glagolClusterProvider,
            std::shared_ptr<IMultiroomProvider> multiroomProvider);
        ~MRForwarderCapability();

    public: // IDirectiveHandler implementation
        const std::string& getEndpointId() const override;
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<YandexIO::Directive>& inDirective) override;

    private:
        const std::shared_ptr<quasar::ICallbackQueue> worker_;
        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::shared_ptr<IGlagolClusterProvider> glagolClusterProvider_;
        const std::shared_ptr<IMultiroomProvider> multiroomProvider_;
    };

} // namespace quasar
