#pragma once

#include "multiroom_slave_player.h"

#include <yandex_io/services/aliced/directive_processor/interface/i_directive_processor.h>
#include <yandex_io/interfaces/clock_tower/i_clock_tower_provider.h>
#include <yandex_io/interfaces/glagol/i_glagol_cluster_provider.h>
#include <yandex_io/interfaces/multiroom/i_multiroom_provider.h>
#include <yandex_io/interfaces/stereo_pair/i_stereo_pair_provider.h>
#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/libs/activity_tracker/interface/i_activity.h>
#include <yandex_io/libs/activity_tracker/activity_tracker.h>
#include <yandex_io/libs/activity_tracker/channel_activity.h>
#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/threading/i_callback_queue.h>
#include <yandex_io/sdk/sdk_interface.h>

namespace quasar {

    class MultiroomEndpoint;
    class MultiroomCapability
        : public YandexIO::IDirectiveHandler,
          public YandexIO::ActivityTracker::Listener {
    public:
        MultiroomCapability(
            std::shared_ptr<quasar::ICallbackQueue> worker,
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<YandexIO::SDKInterface> sdk,
            YandexIO::ActivityTracker& activityTracker,
            YandexIO::IDirectiveProcessorWeakPtr directiveProcessor,
            std::shared_ptr<ipc::IConnector> audioClientConnector,
            std::shared_ptr<IClockTowerProvider> clockTowerProvider,
            std::shared_ptr<IGlagolClusterProvider> glagolClusterProvider,
            std::shared_ptr<IMultiroomProvider> multiroomProvider,
            std::shared_ptr<IStereoPairProvider> stereoPairProvider,
            std::shared_ptr<IUserConfigProvider> userConfigProvider);
        ~MultiroomCapability();

        void onAudioClientEvent(const proto::AudioClientEvent& event);

    public: // IDirectiveHandler implementation
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void cancelDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void prefetchDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;

    private:
        void onActivityAdded(const YandexIO::IActivityConstPtr& activity) override;
        void onActivityRemoved(const YandexIO::IActivityConstPtr& activity) override;

    private:
        void updateActivities();
        void onMultiroomState(const std::shared_ptr<const MultiroomState>& newMultiroomState);

    private:
        const std::shared_ptr<quasar::ICallbackQueue> worker_;
        Lifetime lifetime_;
        YandexIO::ActivityTracker& activityTracker_;
        const YandexIO::IDirectiveProcessorWeakPtr directiveProcessor_;
        const std::shared_ptr<IMultiroomProvider> multiroomProvider_;
        const std::shared_ptr<YandexIO::ActivityTracker::Listener> listener_;
        const std::chrono::milliseconds defaultLatency_;

        YandexIO::ChannelActivityPtr dialogActivity_;
        YandexIO::ChannelActivityPtr slaveActivity_;
        MultiroomSlavePlayer multiroomSlavePlayer_;
        std::shared_ptr<const MultiroomState> multiroomState_;
        int localDialogActivity_{0};

        enum class ActivityAction {
            REMOVE,
            ADD,
        };
        std::vector<std::pair<ActivityAction, YandexIO::ChannelActivityPtr>> unprocessedActivities_;
        std::map<std::shared_ptr<YandexIO::Directive>, MultiroomPlayerDescriptor> history_;

        std::shared_ptr<MultiroomEndpoint> multiroomEndpoint_;
    };

} // namespace quasar
