#pragma once

#include <yandex_io/libs/ipc/message.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/protos/model_objects.pb.h>

#include <optional>

namespace quasar {

    Json::Value multiroomBroadcastToJson(const proto::MultiroomBroadcast& multiroomBroadcast);
    proto::MultiroomBroadcast jsonToMultiroomBroadcast(const Json::Value& jMultiroomBroadcast);

    Json::Value multiroomParamsToJson(const proto::MultiroomParams& multiroomParams);
    proto::MultiroomParams jsonToMultiroomParams(const Json::Value& jMultiroomParams);

    std::string appStateHash(const proto::AppState& appState);

    struct MultiroomShortAppState {
        enum class Player {
            OTHER,
            AUDIO_CLIENT,
            YANDEX_MUSIC,
            MULTIROOM,

            RADIO,
            BLUETOOTH,
            VIDEO,
        };

        struct Normalization {
            double truePeak{0.};
            double integratedLoudness{0.};
            double targetLufs = {0.};
        };

        Player player = Player::OTHER;
        bool sync = false;
        bool isPlaying = false;
        std::string url;
        int64_t basetimeNs = 0;
        int64_t positionNs = 0;
        std::optional<Normalization> normalization;
        std::string multiroomToken;
        std::string vinsRequestId;
        std::string playPauseId;

        bool isMaster() const;
        bool isSlave() const;
        const char* playerName() const;
    };
    MultiroomShortAppState makeMultiroomShortAppState(const proto::AppState& appState);
    MultiroomShortAppState makeMultiroomShortAppState(const proto::MultiroomBroadcast& multiroomBroadcast);

    std::string multiroomSessionId(const proto::MultiroomBroadcast& multiroomBroadcast);

    struct MultiroomSessionId {
        std::string deviceId;
        std::string multiroomToken;
        int64_t sessionTimestampMs{0};
    };
    std::optional<MultiroomSessionId> tryPasrseMultiroomSessionId(const std::string& text);
    std::string makeMultiroomSessionId(const proto::MultiroomBroadcast& multiroomBroadcast);
    std::string makeMultiroomTrackId(const proto::MultiroomBroadcast& multiroomBroadcast);

    std::string printMultiroomBroadcastCompact(const proto::MultiroomBroadcast& message);
    std::string printMultiroomStateCompact(const proto::MultiroomState& message);
    std::string printClockTimestamp(int64_t timestampNs);
    std::string printMultiroomShortAppState(const MultiroomShortAppState& shortAppState);

    std::string hashMultiroomBroadcast(const proto::MultiroomBroadcast& message);
    std::string hashMultiroomState(const proto::MultiroomState& message);

} // namespace quasar
