#include "multiroom_directives.h"

#include <yandex_io/libs/base/directives.h>
#include <yandex_io/libs/protobuf_utils/json.h>

using namespace quasar;

std::shared_ptr<YandexIO::Directive> MultiroomDirectives::createDirectiveSlavePlay(const proto::MultiroomBroadcast& multiroomBroadcast) {
    auto jsonOpt = convertMessageToJson(multiroomBroadcast);
    if (!jsonOpt) {
        throw std::runtime_error("Fail to create MultiroomDirectives::PLAY");
    }

    YandexIO::Directive::Data data(SLAVE_PLAY, "local_action");
    data.payload = std::move(*jsonOpt);
    data.channel = proto::AudioChannel::CONTENT_CHANNEL;

    return std::make_shared<YandexIO::Directive>(std::move(data));
}

std::shared_ptr<YandexIO::Directive> MultiroomDirectives::createDirectiveSlaveStop(std::string_view multiroomSessionId, std::string_view reason) {
    Json::Value payload;
    payload["multiroom_session_id"] = std::string(multiroomSessionId);
    payload["reason"] = std::string(reason);
    YandexIO::Directive::Data data(SLAVE_STOP, "local_action");
    data.payload = std::move(payload);
    return std::make_shared<YandexIO::Directive>(std::move(data));
}

std::shared_ptr<YandexIO::Directive> MultiroomDirectives::createDirectiveSlavePause(std::string_view multiroomSessionId, std::string_view reason) {
    Json::Value payload;
    payload["multiroom_session_id"] = std::string(multiroomSessionId);
    payload["reason"] = std::string(reason);
    YandexIO::Directive::Data data(SLAVE_PAUSE, "local_action");
    data.payload = std::move(payload);
    return std::make_shared<YandexIO::Directive>(std::move(data));
}
