#pragma once

#include <yandex_io/sdk/interfaces/directive.h>
#include <yandex_io/protos/model_objects.pb.h>

namespace quasar {
    class MultiroomDirectives {
    public:
        static constexpr const char* SLAVE_PLAY = "multiroom_slave_play";
        static constexpr const char* SLAVE_STOP = "multiroom_slave_stop";
        static constexpr const char* SLAVE_PAUSE = "multiroom_slave_pause";

        static std::shared_ptr<YandexIO::Directive> createDirectiveSlavePlay(const proto::MultiroomBroadcast& multiroomBroadcast);
        static std::shared_ptr<YandexIO::Directive> createDirectiveSlaveStop(std::string_view multiroomSessionId, std::string_view reason);
        static std::shared_ptr<YandexIO::Directive> createDirectiveSlavePause(std::string_view multiroomSessionId, std::string_view reason);
    };
} // namespace quasar
