#pragma once

#include <yandex_io/interfaces/multiroom/i_multiroom_provider.h>
#include <yandex_io/services/aliced/device_state/alice_device_state.h>
#include <yandex_io/services/aliced/directive_processor/interface/i_directive_preprocessor.h>

namespace quasar {

    class MultiroomPreprocessor: public YandexIO::IDirectivePreprocessor {
    public:
        MultiroomPreprocessor(
            std::string deviceId,
            std::shared_ptr<IMultiroomProvider> multiroomProvider,
            std::shared_ptr<const AliceDeviceState> aliceDeviceState);

        const std::string& getPreprocessorName() const override;
        void preprocessDirectives(std::list<std::shared_ptr<YandexIO::Directive>>& directives) override;

    private:
        void forwardDirectives(std::list<std::shared_ptr<YandexIO::Directive>>& directives);
        void ensureMultiroomToken(std::list<std::shared_ptr<YandexIO::Directive>>& directives);

    private:
        const std::string deviceId_;
        const std::shared_ptr<IMultiroomProvider> multiroomProvider_;
        const std::shared_ptr<const AliceDeviceState> aliceDeviceState_;
        std::string lastMultiroomVinsRequestId_;
        std::string lastMultiroomToken_;
    };

} // namespace quasar
