#pragma once

#include <yandex_io/libs/activity_tracker/interface/i_activity.h>
#include <yandex_io/libs/activity_tracker/activity_tracker.h>
#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/sdk/private/device_context.h>
#include <yandex_io/protos/model_objects.pb.h>

#include <deque>

namespace quasar {
    struct MultiroomPlayerDescriptor {
        std::string multiroomSessionId;
        std::string multiroomTrackId;
        std::string playerId;
        std::string streamId;
    };

    class MultiroomSlavePlayer {
    public:
        MultiroomSlavePlayer(
            std::shared_ptr<ipc::IConnector> audioClientConnector);
        ~MultiroomSlavePlayer();

        void setLatency(std::chrono::milliseconds latencyMs);
        void onAudioClientEvent(const proto::AudioClientEvent& event);

        MultiroomPlayerDescriptor play(const proto::MultiroomBroadcast& multiroomBroadcast);
        void stop(std::string_view multiroomSessionId, std::string_view reason);
        void pause(std::string_view multiroomSessionId, std::string_view reason);

    private:
        enum StopAction {
            STOP,
            PAUSE,
        };
        void stop(std::string_view multiroomSessionId, std::string_view reason, StopAction stopAction);
        static void buildAudio(proto::Audio& outAudio, const proto::MultiroomBroadcast& multiroomBroadcast);

    private:
        const std::shared_ptr<ipc::IConnector> audioClientConnector_;

        std::atomic<int64_t> latencyNs_{0};

        std::optional<proto::AudioClientEvent> playerState_;
        std::optional<proto::MultiroomBroadcast> multiroomBroadcast_;
        std::deque<MultiroomPlayerDescriptor> history_;
    };

} // namespace quasar
