#pragma once

#include <yandex_io/services/aliced/device_state/alice_device_state.h>
#include <yandex_io/services/aliced/directive_processor/interface/i_directive_processor.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/capabilities/playback_control/interfaces/i_playback_control_capability.h>
#include <yandex_io/modules/testpoint/testpoint_peer.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/protos/model_objects.pb.h>
#include <yandex_io/sdk/private/device_context.h>
#include <yandex_io/sdk/private/remoting/i_remote_object.h>
#include <yandex_io/sdk/private/remoting/i_remoting_registry.h>
#include <yandex_io/sdk/interfaces/i_capability.h>

#include <memory>

namespace YandexIO {

    class PlaybackControlCapability
        : public IDirectiveHandler,
          public IPlaybackControlCapability,
          public IRemoteObject,
          public ICapability::IListener,
          public std::enable_shared_from_this<PlaybackControlCapability> {
    public:
        PlaybackControlCapability(
            std::shared_ptr<quasar::ICallbackQueue> worker,
            const std::shared_ptr<YandexIO::IDevice>& device,
            std::shared_ptr<YandexIO::IDirectiveProcessor> directiveProcessor,
            const quasar::AliceDeviceState& aliceDeviceState,
            std::shared_ptr<quasar::ipc::IConnector> glagolConnector,
            std::shared_ptr<quasar::ipc::IConnector> interfaceConnector,
            std::weak_ptr<IRemotingRegistry> remoteRegistry);

        void init();
        void onPassportUidChanged();
        void onQuasarMessage(const quasar::ipc::SharedMessage& message);
        void onDeviceStatePart(const yandex_io::proto::TDeviceStatePart& statePart);

        void setTestpointPeer(std::shared_ptr<TestpointPeer> testpointPeer);

    public:
        // IPlaybackControlCapability
        void play() override;
        void pause() override;
        void togglePlayPause(bool canRequestMusic) override;
        void rewind(std::uint32_t time) override;
        void like() override;
        void dislike() override;
        void next() override;
        void prev() override;

        // IDirectiveHandler
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<Directive>& directive) override;
        void cancelDirective(const std::shared_ptr<Directive>& directive) override;
        void prefetchDirective(const std::shared_ptr<Directive>& directive) override;

        // ICapability::IListener
        void onCapabilityStateChanged(const std::shared_ptr<YandexIO::ICapability>& capability, const NAlice::TCapabilityHolder& state) override;
        void onCapabilityEvents(const std::shared_ptr<YandexIO::ICapability>& capability, const std::vector<NAlice::TCapabilityEvent>& events) override;

    private:
        // Directive handlers
        void handleNext(std::shared_ptr<YandexIO::Directive> directive);
        void handlePrev(std::shared_ptr<YandexIO::Directive> directive);
        void handlePlay(std::shared_ptr<YandexIO::Directive> directive);
        void handlePause(std::shared_ptr<YandexIO::Directive> directive);
        void handleRewind(std::shared_ptr<YandexIO::Directive> directive);
        void handleLike(std::shared_ptr<YandexIO::Directive> directive);
        void handleDislike(std::shared_ptr<YandexIO::Directive> directive);
        void handleTogglePlayPause(std::shared_ptr<YandexIO::Directive> directive);

    private:
        // IRemoteObject
        void handleRemotingMessage(const quasar::proto::Remoting& message, std::shared_ptr<YandexIO::IRemotingConnection> connection) override;

    private:
        bool isLegacyPlayer(const quasar::AudioPlayerType& playerType) const;

        void broadcastSimplePlayerState();
        quasar::ipc::SharedMessage formatValidSimplePlayerState() const;
        quasar::ipc::SharedMessage formatSimplePlayerState() const;
        quasar::ipc::SharedMessage formatMusicSimplePlayerState() const;
        quasar::ipc::SharedMessage formatRadioSimplePlayerState() const;
        quasar::ipc::SharedMessage formatAudioClientSimplePlayerState() const;
        quasar::ipc::SharedMessage formatVideoSimplePlayerState(const yandex_io::proto::TVideo& video) const;

        int64_t getAudioPlayerLastPlayTs() const;
        int64_t getAudioPlayerLastStopTs() const;

    private:
        const std::shared_ptr<quasar::ICallbackQueue> worker_;
        const std::shared_ptr<YandexIO::IDirectiveProcessor> directiveProcessor_;
        const quasar::AliceDeviceState& aliceDeviceState_;
        const bool hasInterfaced_;
        const std::shared_ptr<quasar::ipc::IConnector> glagolConnector_;
        const std::shared_ptr<quasar::ipc::IConnector> interfaceConnector_;

        bool showSimplePlayer_ = false;
        yandex_io::proto::TVideo::ScreenType currentScreenType_ = yandex_io::proto::TVideo_ScreenType_other;
        std::shared_ptr<TestpointPeer> testpointPeer_;

        NAlice::TDeviceStateCapability::TState state_;
    };

} // namespace YandexIO
