#pragma once

#include <yandex_io/capabilities/device_state/interfaces/i_device_state_capability.h>
#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/sdk/private/device_context.h>
#include <yandex_io/services/aliced/device_state/alice_device_state.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/services/aliced/directive_processor/interface/i_directive_preprocessor.h>
#include <yandex_io/services/aliced/directive_processor/interface/i_directive_processor.h>
#include <yandex_io/services/aliced/device_state/alice_device_state.h>
#include <yandex_io/libs/threading/i_callback_queue.h>

#include <memory>
#include <string>

namespace YandexIO {

    class ScreenCapability
        : public YandexIO::IDirectiveHandler,
          public YandexIO::IDirectivePreprocessor {
    public:
        ScreenCapability(std::shared_ptr<IDeviceStateCapability> deviceStateCapability,
                         std::shared_ptr<quasar::ICallbackQueue> worker,
                         IDirectiveProcessorWeakPtr directiveProcessor,
                         const quasar::AliceDeviceState& aliceDeviceState,
                         std::shared_ptr<quasar::ipc::IConnector> interfacedConnector);

        void onAppState(const quasar::proto::AppState& appState);
        void onIsScreenActive(bool isScreenActive);

        // IDirectiveHandler implementation
        //
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void cancelDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void prefetchDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;

        // IDirectivePreprocessor implementation
        //
        const std::string& getPreprocessorName() const override;
        void preprocessDirectives(std::list<std::shared_ptr<Directive>>& directives) override;

    private:
        void handleVideoPlay(const Json::Value& payload, const std::string& vinsRequestId);
        void handleEpisodeAnnounce(const Json::Value& payload);
        void handleShowHomeScreen();
        void handleGoForward(const std::string& vinsRequestId);
        void handleGoBackward(const Json::Value& payload, const std::string& vinsRequestId);
        void handleGoUp(const std::string& vinsRequestId);
        void handleGoDown(const std::string& vinsRequestId);
        void handleGoToTheBeginning(const std::string& vinsRequestId);
        void handleGoToTheEnd(const std::string& vinsRequestId);
        void handleGoTop(const std::string& vinsRequestId);
        void handleScreenOn();
        void handleScreenOff();
        void handleThereminPlay(const Json::Value& payload);
        void handleMordoviaShow(const Json::Value& payload, const std::string& vinsRequestId);
        void handleMordoviaCommand(const Json::Value& payload, const std::string& vinsRequestId);
        void handleOnboardingPlay();
        void handleOnboardingSkip();
        void handleChangeAudio(const Json::Value& payload);
        void handleChangeSubtitles(const Json::Value& payload);
        void handleShowVideoSettings();
        void handlePayScreen(const Json::Value& payload);
        void handleGallery(const Json::Value& payload,
                           const std::string& outputSpeech,
                           const std::string& lastRecognizedPhrase,
                           quasar::proto::GalleryType galleryType);
        void handleDescription(const Json::Value& payload);
        void handleSetupRcu();
        void handleSetupRcuAuto(const Json::Value& payload);
        void handleSetupRcuCheck();
        void handleSetupRcuAdvanced();
        void handleSetupRcuManual();

        static void convert(const Json::Value& item, quasar::proto::MediaItem* mediaItem);
        static quasar::proto::QuasarMessage buildVideoPlayMessage(const Json::Value& payload, const std::string& vinsRequestId);

    private:
        static quasar::proto::Provider parseProvider(const std::string& providerName);
        static quasar::proto::SkippableFragments::Type parseSkippableFragmentType(const std::string& fragmentType);
        static quasar::proto::MediaItem::Type convertType(const std::string& type);
        static quasar::proto::MediaItem::StreamType convertStreamType(const std::string& type);

    private:
        bool isActive_ = false;
        bool isHdmiConnected_ = false;
        int64_t lastPlayVideoTs_ = 0;
        int screenType_{-1};

        const std::shared_ptr<IDeviceStateCapability> deviceStateCapability_;
        const std::shared_ptr<quasar::ipc::IConnector> interfaceConnector_;
        const std::shared_ptr<quasar::ICallbackQueue> worker_;
        const IDirectiveProcessorWeakPtr directiveProcessor_;
        const quasar::AliceDeviceState& aliceDeviceState_;
    };

} // namespace YandexIO
