#pragma once

#include <yandex_io/sdk/private/remoting/i_remote_object.h>
#include <yandex_io/sdk/private/remoting/i_remoting_registry.h>
#include <yandex_io/services/aliced/alice_config/alice_config.h>
#include <yandex_io/services/aliced/device_state/alice_device_state.h>
#include <yandex_io/services/aliced/speechkit_facade/quasar_voice_dialog.h>

#include <map>
#include <memory>

namespace quasar {

    class ActivationSpotterCapability
        : public YandexIO::IRemoteObject,
          public std::enable_shared_from_this<ActivationSpotterCapability> {
    public:
        ActivationSpotterCapability(
            std::shared_ptr<quasar::ICallbackQueue> callbackQueue,
            const AliceConfig& aliceConfig,
            std::shared_ptr<QuasarVoiceDialog> voiceDialog,
            AliceDeviceState& deviceState,
            std::weak_ptr<YandexIO::IRemotingRegistry> remotingRegistry);

        ~ActivationSpotterCapability();

        void init();
        void start();
        const std::map<std::string, std::string>& getModelPaths() const;
        void onModelError();

        // YandexIO::IRemoteObject implementation
        void handleRemotingMessage(
            const quasar::proto::Remoting& message,
            std::shared_ptr<YandexIO::IRemotingConnection> connection) override;

    private:
        void updateVoiceDialogSettings();
        bool isConfigured() const;
        void remoteNotifyModelError();
        void remoteNotifyModelSet();
        void processSetModelPaths(
            const google::protobuf::RepeatedPtrField<quasar::proto::Remoting::SpotterCapabilityMethod::ModelPath>& modelPaths);
        void processSetSpotterWord(const std::string& spotterWord);

    private:
        std::shared_ptr<quasar::ICallbackQueue> callbackQueue_;
        const AliceConfig& aliceConfig_;
        std::shared_ptr<QuasarVoiceDialog> voiceDialog_;
        AliceDeviceState& deviceState_;
        std::shared_ptr<YandexIO::IRemotingConnection> connection_;
        std::map<std::string, std::string> typeToModelPaths_;
        bool pendingStartSpotter_{false};
    };

} // namespace quasar
