#pragma once

#include <yandex_io/capabilities/alarm/interfaces/i_alarm_capability_listener.h>
#include <yandex_io/capabilities/alice/interfaces/i_alice_capability_listener.h>
#include <yandex_io/capabilities/alice/interfaces/i_alice_capability.h>
#include <yandex_io/capabilities/playback_control/interfaces/i_playback_control_capability.h>
#include <yandex_io/sdk/interfaces/i_capability.h>
#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/spotter_types/spotter_types.h>
#include <yandex_io/libs/telemetry/telemetry.h>
#include <yandex_io/sdk/private/remoting/i_remote_object.h>
#include <yandex_io/sdk/private/remoting/i_remoting_registry.h>
#include <yandex_io/services/aliced/alice_config/alice_config.h>
#include <yandex_io/services/aliced/device_state/i_alice_device_state.h>
#include <yandex_io/services/aliced/speechkit_facade/quasar_voice_dialog.h>
#include <yandex_io/services/aliced/directive_processor/interface/i_directive_processor.h>

#include <speechkit/Error.h>
#include <speechkit/PhraseSpotterSettings.h>

#include <json/json-forwards.h>

#include <map>
#include <memory>
#include <set>
#include <string>

namespace quasar {

    class CommandSpotterCapability
        : public YandexIO::IAlarmCapabilityListener,
          public YandexIO::IAliceCapabilityListener,
          public YandexIO::ICapability::IListener,
          public YandexIO::IRemoteObject,
          public std::enable_shared_from_this<CommandSpotterCapability> {
    public:
        CommandSpotterCapability(
            std::shared_ptr<quasar::ICallbackQueue> worker,
            const AliceConfig& aliceConfig,
            IAliceDeviceState& deviceState,
            std::weak_ptr<YandexIO::IDirectiveProcessor> directiveProcessor,
            std::shared_ptr<YandexIO::ITelemetry> telemetry,
            std::weak_ptr<YandexIO::IAliceCapability> aliceCapability,
            std::weak_ptr<YandexIO::IPlaybackControlCapability> playbackCapability,
            std::shared_ptr<QuasarVoiceDialog> voiceDialog,
            std::weak_ptr<YandexIO::IRemotingRegistry> remotingRegistry);
        ~CommandSpotterCapability();

        void init();

        void onCommandSpotterBegin();
        void onCommandPhraseSpotted(const std::string& phrase);
        void onCommandSpotterError(const SpeechKit::Error& error);

        void onConfigUpdated();
        void onStateUpdated();

    private:
        void onModelsUpdated();
        void startCommandSpotter(const std::string& newSpotterType, bool forceRecreate);
        void handlePhrase(const std::string& phrase);
        SpeechKit::PhraseSpotterSettings getSpotterSettings() const;
        std::string defineSpotterType() const;
        void pushCommandDirective(const std::string& directive);

        bool isSpotterEnabled(const std::string& spotterType) const;
        bool isPhraseEnabled(const std::string& phrase) const;
        void logSpotterCommand(const std::string& command, std::string_view spotterType, const std::string& spotterModel);

        // IAlarmCapabilityListener implementation
        void onAlarmStarted() override;
        void onAlarmStopped() override;
        void onAlarmEnqueued(const quasar::proto::Alarm& alarm) override;

        // YandexIO::IAliceCapabilityListener implementation
        void onAliceStateChanged(quasar::proto::AliceState state) override;
        void onAliceTtsCompleted() override;

        // YandexIO::IRemoteObject implementation
        void handleRemotingMessage(
            const quasar::proto::Remoting& message,
            std::shared_ptr<YandexIO::IRemotingConnection> connection) override;

        // YandexIO::ICapability::IListener
        void onCapabilityStateChanged(const std::shared_ptr<YandexIO::ICapability>& capability, const NAlice::TCapabilityHolder& state) override;
        void onCapabilityEvents(const std::shared_ptr<YandexIO::ICapability>& capability, const std::vector<NAlice::TCapabilityEvent>& events) override;

    private:
        void initDisabledPhrases();
        void initDisabledSpotters();
        void stop();
        bool isConfigEnabled();
        bool isAliceInCommandState();
        void updateSpotterState(bool forceRecreate);
        void remoteNotifyModelSet(const std::set<std::string>& types);
        void remoteNotifyModelError();

    private:
        bool isActive_{false};
        std::shared_ptr<quasar::ICallbackQueue> worker_;
        std::weak_ptr<YandexIO::IDirectiveProcessor> directiveProcessor_;
        std::string spotterType_;
        std::set<std::string> disabledPhrases_;
        std::set<std::string> disabledSpotters_;
        std::map<std::string, std::string> spottersModels_;
        std::shared_ptr<YandexIO::ITelemetry> telemetry_;
        const AliceConfig& aliceConfig_;
        IAliceDeviceState& deviceState_;
        std::weak_ptr<YandexIO::IAliceCapability> aliceCapability_;
        std::weak_ptr<YandexIO::IPlaybackControlCapability> playbackCapability_;
        proto::AliceState::State aliceState_ = proto::AliceState::NONE;
        std::shared_ptr<QuasarVoiceDialog> voiceDialog_;
        std::shared_ptr<YandexIO::IRemotingConnection> connection_;
    };

} // namespace quasar
