#pragma once

#include <yandex_io/capabilities/alice/interfaces/i_alice_capability_listener.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/sdk/private/remoting/i_remote_object.h>
#include <yandex_io/sdk/private/remoting/i_remoting_registry.h>
#include <yandex_io/services/aliced/alice_config/alice_config.h>
#include <yandex_io/services/aliced/device_state/alice_device_state.h>
#include <yandex_io/services/aliced/directive_processor/interface/i_directive_processor.h>

#include <speechkit/AudioSource.h>
#include <speechkit/PhraseSpotter.h>
#include <speechkit/PhraseSpotterSettings.h>

#include <memory>

namespace quasar {

    class NaviOldSpotterCapability
        : public SpeechKit::PhraseSpotter::PhraseSpotterListener,
          public YandexIO::IAliceCapabilityListener,
          public YandexIO::IRemoteObject,
          public YandexIO::ICapability::IListener,
          public std::enable_shared_from_this<NaviOldSpotterCapability> {
    public:
        NaviOldSpotterCapability(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<SpeechKit::AudioSource> audioSource,
            std::weak_ptr<YandexIO::IDirectiveProcessor> directiveProcessor,
            const AliceConfig& aliceConfig,
            AliceDeviceState& aliceDeviceState,
            std::shared_ptr<quasar::ICallbackQueue> worker,
            std::weak_ptr<YandexIO::IRemotingRegistry> remotingRegistry);
        ~NaviOldSpotterCapability();
        void init();

        void resume();

        void logSpotterCommand(const std::string& command, std::string_view spotterType, const std::string& spotterModel);

        void onCapabilityStateChanged(const std::shared_ptr<YandexIO::ICapability>& capability, const NAlice::TCapabilityHolder& state) override;
        void onCapabilityEvents(const std::shared_ptr<YandexIO::ICapability>& capability, const std::vector<NAlice::TCapabilityEvent>& events) override;

    private:
        void start();
        void stop();
        void restart();
        void suspend();
        void remoteNotifyModelSet();
        void remoteNotifyModelError();

        // PhraseSpotter::PhraseSpotterListener implementation
        void onPhraseSpotted(
            SpeechKit::PhraseSpotter::SharedPtr phraseSpotter,
            const std::string& phrase,
            int phraseId,
            const std::string& channelName) override;
        void onPhraseSpotterStarted(SpeechKit::PhraseSpotter::SharedPtr phraseSpotter) override;
        void onPhraseSpotterError(SpeechKit::PhraseSpotter::SharedPtr phraseSpotter, const SpeechKit::Error& error) override;

        // YandexIO::IAliceCapabilityListener implementation
        void onAliceStateChanged(quasar::proto::AliceState state) override;
        void onAliceTtsCompleted() override;

        // YandexIO::IRemoteObject implementation
        void handleRemotingMessage(
            const quasar::proto::Remoting& message,
            std::shared_ptr<YandexIO::IRemotingConnection> connection) override;

    private:
        enum State {
            STARTED,
            STOPPED,
            SUSPENDED
        };

        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::shared_ptr<SpeechKit::AudioSource> audioSource_;
        const AliceConfig& aliceConfig_;
        AliceDeviceState& aliceDeviceState_;
        ::SpeechKit::PhraseSpotter::SharedPtr phraseSpotter_;
        ::SpeechKit::PhraseSpotterSettings settings_{""};
        std::map<std::string, std::string> recognizedPhraseToDirectiveMap_;
        std::weak_ptr<YandexIO::IDirectiveProcessor> directiveProcessor_;
        State state_ = State::STOPPED;
        proto::AliceState aliceState_;
        const std::shared_ptr<quasar::ICallbackQueue> worker_;
        std::shared_ptr<YandexIO::IRemotingConnection> connection_;
        std::string modelPath_;
    };

} // namespace quasar
