#include "spotter_phrases.h"

#include <vector>

using namespace quasar;

namespace {
    bool containsAny(const std::string& string, const std::vector<std::string>& subStrings) {
        for (const auto& subString : subStrings) {
            if (string.find(subString) != std::string::npos) {
                return true;
            }
        }
        return false;
    }
} // namespace

bool SpotterPhrases::isStop(const std::string& text) {
    return containsAny(text, {"стоп", "заткнись", "хватит", "замолчи"});
}

bool SpotterPhrases::isContinuePlaying(const std::string& text) {
    return containsAny(text, {"продолжи"});
}

bool SpotterPhrases::isGoUp(const std::string& text) {
    return containsAny(text, {"выше", "вверх", "наверх"});
}

bool SpotterPhrases::isGoDown(const std::string& text) {
    return containsAny(text, {"ниже", "вниз"});
}

bool SpotterPhrases::isGoBackward(const std::string& text) {
    return containsAny(text, {"назад"});
}

bool SpotterPhrases::isGoForward(const std::string& text) {
    return containsAny(text, {"дальше"});
}

bool SpotterPhrases::isMakeLouder(const std::string& text) {
    return containsAny(text, {"громче"});
}

bool SpotterPhrases::isMakeQuieter(const std::string& text) {
    return containsAny(text, {"тише"});
}

bool SpotterPhrases::isNextTrack(const std::string& text) {
    return containsAny(text, {"дальше", "следующий"});
}

bool SpotterPhrases::isTurnOn(const std::string& text) {
    return containsAny(text, {"включи"});
}
