#include "stereo_pair_capability.h"

#include "stereo_pair_directives.h"

#include <yandex_io/libs/base/directives.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/logging/logging.h>

YIO_DEFINE_LOG_MODULE("stereo_pair_capability");

using namespace quasar;

StereoPairCapability::StereoPairCapability(std::shared_ptr<IStereoPairProvider> stereoPairProvider)
    : stereoPairProvider_(std::move(stereoPairProvider))
{
}

const std::string& StereoPairCapability::getHandlerName() const {
    static const std::string s_name = "StereoPairCapability";
    return s_name;
}

const std::set<std::string>& StereoPairCapability::getSupportedDirectiveNames() const {
    static std::set<std::string> s_names = {
        StereoPairDirectives::NO_CONNECTION_NOTIFICATION,
        StereoPairDirectives::PLAYER_NOT_READY_NOTIFICATION,
    };
    return s_names;
}

void StereoPairCapability::handleDirective(const std::shared_ptr<YandexIO::Directive>& directive)
{
    if (!stereoPairProvider_) {
        return;
    }

    if (directive->is(StereoPairDirectives::NO_CONNECTION_NOTIFICATION)) {
        stereoPairProvider_->speakNotReadyNotification(IStereoPairProvider::NotReadyReason::NO_CONNECTION);
    } else if (directive->is(StereoPairDirectives::PLAYER_NOT_READY_NOTIFICATION)) {
        stereoPairProvider_->speakNotReadyNotification(IStereoPairProvider::NotReadyReason::PLAYER_NOT_READY);
    }
}

void StereoPairCapability::cancelDirective(const std::shared_ptr<YandexIO::Directive>& /*directive*/)
{
    // do nothing
}

void StereoPairCapability::prefetchDirective(const std::shared_ptr<YandexIO::Directive>& /*directive*/)
{
    // do nothing
}
