#pragma once

#include <yandex_io/interfaces/stereo_pair/i_stereo_pair_provider.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>

namespace quasar {

    class StereoPairCapability
        : public YandexIO::IDirectiveHandler {
    public:
        StereoPairCapability(std::shared_ptr<IStereoPairProvider> stereoPairProvider);

    public: // IDirectiveHandler implementation
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void cancelDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void prefetchDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;

    private:
        const std::shared_ptr<IStereoPairProvider> stereoPairProvider_;
    };

} // namespace quasar
