#pragma once

#include <yandex_io/services/aliced/directive_processor/interface/i_directive_preprocessor.h>

#include <yandex_io/interfaces/stereo_pair/i_stereo_pair_provider.h>
#include <yandex_io/interfaces/user_config/i_user_config_provider.h>

#include <set>

namespace quasar {

    class StereoPairPreprocessor: public YandexIO::IDirectivePreprocessor {
    public:
        StereoPairPreprocessor(
            std::shared_ptr<IStereoPairProvider> stereoPairProvider,
            std::shared_ptr<IUserConfigProvider> userConfigProvider);
        ~StereoPairPreprocessor();

        const std::string& getPreprocessorName() const override;
        void preprocessDirectives(std::list<std::shared_ptr<YandexIO::Directive>>& directives) override;

    private:
        Lifetime lifetime_;
        const std::set<std::string> followerProhibitedDirectives_;
        const std::shared_ptr<IStereoPairProvider> stereoPairProvider_;
        const std::shared_ptr<IUserConfigProvider> userConfigProvider_;
        std::atomic<bool> ignorePartnerReady_{false};
    };

} // namespace quasar
