#include "tandem_config.h"

#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>

using namespace quasar;
using namespace YandexIO;

YIO_DEFINE_LOG_MODULE("tandem_config");

proto::DeviceGroupState::Role TandemConfig::getRole(const std::string& endpointId) const {
    if (endpointId == speakerEndpointId) {
        return proto::DeviceGroupState::Role::DeviceGroupState_Role_LEADER;
    }
    if (endpointId == moduleEndpointId) {
        return proto::DeviceGroupState::Role::DeviceGroupState_Role_FOLLOWER;
    }

    return proto::DeviceGroupState::Role::DeviceGroupState_Role_STAND_ALONE;
}

proto::DeviceGroupState::Leader TandemConfig::getLeader() const {
    proto::DeviceGroupState::Leader leader;
    leader.set_device_id(TString(speakerEndpointId));
    leader.set_platform(TString(speakerPlatform));
    leader.set_connection_state(proto::DeviceGroupState::NONE);

    return leader;
}

proto::DeviceGroupState::Follower TandemConfig::getFollower() const {
    proto::DeviceGroupState::Follower follower;
    follower.set_device_id(TString(moduleEndpointId));
    follower.set_platform(TString(modulePlatform));
    follower.set_connection_state(proto::DeviceGroupState::NONE);

    return follower;
}

std::string TandemConfig::getRemoteEndpointId(const std::string& localEndpointId) const {
    if (speakerEndpointId == localEndpointId) {
        return moduleEndpointId;
    } else if (moduleEndpointId == localEndpointId) {
        return speakerEndpointId;
    }

    return "";
}

TandemConfig TandemConfig::parse(const std::string& json)
{
    Json::Value config;
    config = quasar::parseJson(json);

    TandemConfig tandemConfig;
    tandemConfig.groupId = quasar::tryGetInt(config, "id", -1);

    const auto& devices = config["devices"];
    for (Json::ArrayIndex i = 0; i < devices.size(); ++i) {
        const Json::Value& device = devices[i];

        std::string role = device["role"].asString();
        std::transform(role.begin(), role.end(), role.begin(), ::tolower);

        if (role == "leader") {
            tandemConfig.speakerEndpointId = device["id"].asString();
            tandemConfig.speakerPlatform = device["platform"].asString();
        } else if (role == "follower") {
            tandemConfig.moduleEndpointId = device["id"].asString();
            tandemConfig.modulePlatform = device["platform"].asString();
        }
    }

    return tandemConfig;
}
