#pragma once

#include <yandex_io/protos/model_objects.pb.h>

#include <string>

namespace YandexIO {

    struct TandemConfig {
        int groupId;
        std::string moduleEndpointId;
        std::string modulePlatform;
        std::string speakerEndpointId;
        std::string speakerPlatform;

    public:
        quasar::proto::DeviceGroupState::Role getRole(const std::string& endpointId) const;
        quasar::proto::DeviceGroupState::Leader getLeader() const;
        quasar::proto::DeviceGroupState::Follower getFollower() const;
        std::string getRemoteEndpointId(const std::string& localEndpointId) const;

    public:
        static TandemConfig parse(const std::string& json);
    };

} // namespace YandexIO
