#pragma once

#include <yandex_io/sdk/interfaces/directive.h>
#include <yandex_io/services/aliced/device_state/alice_device_state.h>
#include <yandex_io/services/aliced/directive_processor/interface/i_directive_processor.h>
#include <yandex_io/sdk/interfaces/i_capability.h>

#include <functional>
#include <unordered_map>

namespace YandexIO {

    class TandemStateHandler {
    public:
        enum class HandlerType {
            LOCAL,
            FOLLOWER,
            BROADCAST
        };

        enum class MediaKeeper {
            LOCAL,
            FOLLOWER
        };

    public:
        TandemStateHandler(
            std::weak_ptr<IDirectiveProcessor> directiveProcessor,
            std::shared_ptr<quasar::AliceDeviceState> deviceState);

        void init();
        void setMediaKeerper(MediaKeeper keeper);
        void handleDeviceGroupState(const quasar::proto::DeviceGroupState& deviceGroupState);
        HandlerType chooseExternalHandlerType(const std::shared_ptr<Directive>& directive);

        void setFollowerDeviceState(std::shared_ptr<ICapability> deviceStateCapability);

    private:
        using Dispatcher = std::function<HandlerType(const std::shared_ptr<Directive>&)>;

    private:
        static HandlerType executeLocal(const std::shared_ptr<Directive>& directive);
        static HandlerType executeBroadcast(const std::shared_ptr<Directive>& directive);
        static HandlerType executeFollower(const std::shared_ptr<Directive>& directive);

        // Dispatchers
        HandlerType volumeCommands(const std::shared_ptr<Directive>& directive);
        HandlerType pauseCommands(const std::shared_ptr<Directive>& directive);

        // Helpers
        bool followerHasVideoScreen() const;
        bool followerHasPlayingVideo() const;

    private:
        std::weak_ptr<IDirectiveProcessor> directiveProcessor_;
        const std::shared_ptr<quasar::AliceDeviceState> deviceState_;
        std::unordered_map<std::string, Dispatcher> directiveHandlerMap_;

        std::shared_ptr<ICapability> deviceStateCapability_;
        bool isFollowerConnected_ = false;
        MediaKeeper currentMediaKeeper_ = MediaKeeper::LOCAL;
        quasar::proto::DeviceGroupState::Role role_ = quasar::proto::DeviceGroupState::STAND_ALONE;
    };

    std::ostream& operator<<(std::ostream& out, TandemStateHandler::MediaKeeper type);

} // namespace YandexIO
