#pragma once

#include <yandex_io/capabilities/alice/interfaces/i_alice_capability.h>
#include <yandex_io/libs/delay_timings_policy/i_delay_timings_policy.h>
#include <yandex_io/sdk/private/remoting/remoting_message_router.h>
#include <yandex_io/sdk/private/endpoint_storage/endpoint_storage_host.h>
#include <yandex_io/services/aliced/alice_config/alice_config.h>
#include <yandex_io/services/aliced/directive_processor/directive_processor.h>
#include <yandex_io/services/aliced/capabilities/legacy_iot_capability/legacy_iot_capability.h>

#include <yandex_io/libs/threading/i_callback_queue.h>

#include <memory>

namespace YandexIO {

    class DeviceController
        : public ICapability::IListener,
          public IEndpoint::IListener,
          public IEndpointStorage::IListener,
          public std::enable_shared_from_this<DeviceController>,
          public IAliceRequestEvents {
    public:
        DeviceController(
            std::shared_ptr<quasar::ICallbackQueue> worker,
            const quasar::AliceConfig& aliceConfig,
            std::shared_ptr<quasar::LegacyIotCapability> legacyIotCapability,
            std::unique_ptr<quasar::IBackoffRetries> backoffer);

        void init(std::string deivceId, NAlice::TEndpoint::EEndpointType type);
        void setAliceCapability(std::weak_ptr<IAliceCapability> aliceCapability);

        const std::shared_ptr<EndpointStorageHost>& getEndpointStorage() const;
        const std::shared_ptr<DirectiveProcessor>& getDirectiveProcessor() const;
        const std::shared_ptr<RemotingMessageRouter>& getRemotingMessageRouter() const;

        void fireCapabilitiesConfig();
        void onIotCapabilityEnabledChanged();

        // IAliceRequestEvents implementation
        void onAliceRequestStarted(std::shared_ptr<VinsRequest> request) override;
        void onAliceRequestCompleted(std::shared_ptr<VinsRequest> request, const Json::Value& response) override;
        void onAliceRequestError(std::shared_ptr<VinsRequest> request, const std::string& errorCode, const std::string& errorText) override;

    private:
        // IEndpointStorage::IListener implementation
        void onEndpointAdded(const std::shared_ptr<IEndpoint>& endpoint) override;
        void onEndpointRemoved(const std::shared_ptr<IEndpoint>& endpoint) override;
        void onCapabilityConfigChanged(const quasar::proto::CapabilityConfig& config) override;

        // ICapability::IListener implementation
        void onCapabilityStateChanged(const std::shared_ptr<ICapability>& capability, const NAlice::TCapabilityHolder& state) override;
        void onCapabilityEvents(const std::shared_ptr<ICapability>& capability, const std::vector<NAlice::TCapabilityEvent>& events) override;

        // IEndpoint::IListener implementation
        void onCapabilityAdded(
            const std::shared_ptr<IEndpoint>& enpdoint,
            const std::shared_ptr<ICapability>& capability) override;
        void onCapabilityRemoved(
            const std::shared_ptr<IEndpoint>& enpdoint,
            const std::shared_ptr<ICapability>& capability) override;

        void onEndpointStateChanged(
            const std::shared_ptr<IEndpoint>& endpoint) override;

    private:
        void sendUpdatedEndpoints();
        void handleEndpointsUpdate();
        void scheduleEndpointUpdate(const std::shared_ptr<IEndpoint>& endpoint, const std::shared_ptr<ICapability>& capability);

        void registerCapability(const std::shared_ptr<ICapability>& capability);
        void unregisterCapability(const std::shared_ptr<ICapability>& capability);

        void sendCapabilityEvents(const std::shared_ptr<IEndpoint>& endpoint, const std::vector<NAlice::TCapabilityEvent>& events);

    private:
        const std::shared_ptr<quasar::ICallbackQueue> worker_;
        bool hasScheduledEndpointUpdate_ = false;

        using UpdatedCapabilities = std::set<
            std::weak_ptr<ICapability>,
            std::owner_less<std::weak_ptr<ICapability>>>;

        using UpdatedEndpoints = std::map<
            std::weak_ptr<IEndpoint>,
            UpdatedCapabilities,
            std::owner_less<std::weak_ptr<IEndpoint>>>;

        UpdatedEndpoints updatedEndpoints_;

        std::shared_ptr<EndpointStorageHost> endpointStorage_;
        const std::shared_ptr<DirectiveProcessor> directiveProcessor_;
        const quasar::AliceConfig& aliceConfig_;
        std::shared_ptr<quasar::LegacyIotCapability> legacyIotCapability_;
        std::shared_ptr<RemotingMessageRouter> remotingMessageRouter_;
        std::weak_ptr<IAliceCapability> aliceCapability_;

        static std::optional<bool> getReportable(const NAlice::TCapabilityHolder& message);
        const std::unique_ptr<quasar::IBackoffRetries> backoffer_;

        struct EndpointEvents {
            std::string endpointId;
            std::vector<NAlice::TCapabilityEvent> events;
        };

        std::unordered_map<std::string, EndpointEvents> eventsBeingSent_;
        std::unordered_map<std::string, std::vector<NAlice::TCapabilityEvent>> eventsToBeSent_;
    };

} // namespace YandexIO
