#pragma once

#include <yandex_io/libs/telemetry/telemetry.h>
#include <yandex_io/protos/quasar_proto.pb.h>
#include <yandex_io/sdk/interfaces/i_endpoint_storage.h>
#include <alice/megamind/protos/common/environment_state.pb.h>
#include <json/json.h>

#include <optional>

class EnvironmentStateHolder {
public:
    using OnEnvironmentChanged = std::function<void()>;

    static const std::string TANDEM_DEVICE_CONNECTED_KEY;
    static const std::string TANDEM_DEVICE_ID_KEY;

    EnvironmentStateHolder(std::string deviceId,
                           std::shared_ptr<YandexIO::ITelemetry> telemetry);

    OnEnvironmentChanged environmentChangedCallback_;

    void enable(bool enabled);
    void updateLocalDevice();
    void updateLocalSubscriptionType(const quasar::proto::SubscriptionState& subscriptionState);
    void updateTandemGroup(const quasar::proto::DeviceGroupState& groupState);
    void updateRemoteDevice(const NAlice::TEnvironmentDeviceInfo& device);
    void updateLocalMediaDeviceIdentifier(const NAlice::TClientInfoProto::TMediaDeviceIdentifier& identifier);
    void setActiveActions(const NAlice::TDeviceState::TActiveActions& payload);

    Json::Value formatJson() const;
    NAlice::TEnvironmentDeviceInfo getLocalDeviceInfo() const;

    void setEndpointStorage(std::shared_ptr<YandexIO::IEndpointStorage> endpointStorage);

private:
    void updateLocalDeviceImpl();

private:
    NAlice::TEnvironmentDeviceInfo localDeviceInfo_;
    NAlice::TEnvironmentDeviceInfo remoteDeviceInfo_; // only one for tandem group now. TODO: migrate to set of devices
    NAlice::TEnvironmentGroupInfo tandemGroup_;
    quasar::proto::DeviceGroupState savedGroupState_;
    bool isEnabled_ = true;
    const std::string deviceId_;
    std::shared_ptr<YandexIO::ITelemetry> telemetry_;
    std::shared_ptr<YandexIO::IEndpointStorage> endpointStorage_;
};
