#pragma once

#include "environment_state.h"

#include <yandex_io/protos/model_objects.pb.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <json/json.h>

namespace quasar {
    class IAliceDeviceState {
    public:
        virtual ~IAliceDeviceState();

        virtual const NAlice::TDeviceState& getDeviceState() const = 0;

        virtual const NAlice::TDeviceState::TVideo& getVideoState() const = 0;

        virtual bool isLongListenerScreen() const = 0;
        virtual bool isMediaPlaying() const = 0;

        virtual Json::Value formatJson() const = 0;

        virtual EnvironmentStateHolder& getEnvironmentState() = 0;
        virtual const EnvironmentStateHolder& getEnvironmentState() const = 0;

        virtual bool hasPlayingAlarm() const = 0;
    };

} // namespace quasar
