#pragma once

#include <yandex_io/services/aliced/device_state/i_alice_device_state.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

#include <functional>

namespace quasar {

    class MockIAliceDeviceState: public IAliceDeviceState {
    public:
        MOCK_METHOD(const NAlice::TDeviceState&, getDeviceState, (), (const, override));
        MOCK_METHOD(const NAlice::TDeviceState::TVideo&, getVideoState, (), (const, override));
        MOCK_METHOD(bool, isLongListenerScreen, (), (const, override));
        MOCK_METHOD(bool, isMediaPlaying, (), (const, override));
        MOCK_METHOD(Json::Value, formatJson, (), (const, override));
        MOCK_METHOD(EnvironmentStateHolder&, getEnvironmentState, (), (override));
        MOCK_METHOD(const EnvironmentStateHolder&, getEnvironmentState, (), (const, override));
        MOCK_METHOD(bool, hasPlayingAlarm, (), (const, override));
    };

} // namespace quasar
