#pragma once

#include <yandex_io/sdk/interfaces/directive.h>

#include <list>
#include <memory>

namespace YandexIO {

    class IDirectivePreprocessor {
    public:
        virtual ~IDirectivePreprocessor();

        virtual const std::string& getPreprocessorName() const = 0;
        virtual void preprocessDirectives(std::list<std::shared_ptr<Directive>>& directives) = 0;
    };

    using IDirectivePreprocessorPtr = std::shared_ptr<IDirectivePreprocessor>;

} // namespace YandexIO
