#pragma once

#include <yandex_io/sdk/interfaces/directive.h>

namespace YandexIO {

    class IDirectiveProcessorListener {
    public:
        enum class Result {
            SUCCESS,
            FAIL,
            CANCELED
        };

    public:
        virtual ~IDirectiveProcessorListener();

        virtual void onSequenceStateChanged() = 0;
        virtual void onDialogChannelIsIdle() = 0;
        virtual void onDirectiveHandled(const std::shared_ptr<Directive>& directive) = 0;
        virtual void onDirectiveStarted(const std::shared_ptr<Directive>& directive) = 0;
        virtual void onDirectiveCompleted(const std::shared_ptr<Directive>& directive, Result result) = 0;
    };

} // namespace YandexIO
