#pragma once

#include <yandex_io/services/aliced/directive_processor/interface/i_directive_processor.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace YandexIO {

    class MockIDirectiveProcessor: public YandexIO::IDirectiveProcessor {
    public:
        ~MockIDirectiveProcessor() = default;

        MOCK_METHOD(bool, addDirectiveHandler, (const YandexIO::IDirectiveHandlerPtr&), (override));
        MOCK_METHOD(bool, removeDirectiveHandler, (const YandexIO::IDirectiveHandlerPtr&), (override));
        MOCK_METHOD(YandexIO::IDirectiveHandlerPtr, findDirectiveHandlerByName, (const std::string&), (const, override));

        MOCK_METHOD(bool, addDirectivePreprocessor, (const YandexIO::IDirectivePreprocessorPtr&), (override));
        MOCK_METHOD(bool, removeDirectivePreprocessor, (const YandexIO::IDirectivePreprocessorPtr&), (override));
        MOCK_METHOD(const std::vector<YandexIO::IDirectivePreprocessorPtr>&, getDirectivePreprocessors, (), (const, override));
        MOCK_METHOD(const std::set<std::string>&, getSupportedDirectiveNames, (), (const, override));

        MOCK_METHOD(void, onHandleDirectiveStarted, (std::shared_ptr<Directive>), (override));
        MOCK_METHOD(void, onHandleDirectiveCompleted, (std::shared_ptr<Directive>, bool), (override));
        MOCK_METHOD(void, onHandleDirectiveCompleted, (std::shared_ptr<Directive>, std::list<std::shared_ptr<Directive>>), (override));
        MOCK_METHOD(void, onPrefetchDirectiveCompleted, (std::shared_ptr<Directive>, std::list<std::shared_ptr<Directive>>), (override));
        MOCK_METHOD(void, addDirectives, (std::list<std::shared_ptr<Directive>>), (override));
        MOCK_METHOD(void, onBlockPrefetchChanged, (std::shared_ptr<Directive>), (override));
        MOCK_METHOD(void, enqueueDirective, (std::shared_ptr<Directive>), (override));
    };

} // namespace YandexIO
