#pragma once

#include <yandex_io/services/aliced/directive_processor/interface/i_directive_processor_listener.h>

#include <yandex_io/sdk/interfaces/directive.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace YandexIO {

    class MockIDirectiveProcessorListener: public IDirectiveProcessorListener {
    public:
        MOCK_METHOD(void, onSequenceStateChanged, (), (override));
        MOCK_METHOD(void, onDialogChannelIsIdle, (), (override));
        MOCK_METHOD(void, onDirectiveHandled, (const std::shared_ptr<Directive>&), (override));
        MOCK_METHOD(void, onDirectiveStarted, (const std::shared_ptr<Directive>&), (override));
        MOCK_METHOD(void, onDirectiveCompleted, (const std::shared_ptr<Directive>&, IDirectiveProcessorListener::Result), (override));
    };

} // namespace YandexIO
