#pragma once

#include "audio_focus_dispatcher.h"
#include "device_controller.h"
#include "capabilities/alice_capability/preprocessors/local_vins_preprocessor.h"
#include "capabilities/spotter_capability/navi_old_spotter_capability.h"
#include "capabilities/spotter_capability/command_spotter_capability.h"
#include "capabilities/spotter_capability/activation_spotter_capability.h"
#include "speechkit_facade/alice_audio_source.h"
#include "speechkit_facade/broken_mic_info_logger.h"
#include "speechkit_facade/quasar_voice_dialog.h"

#include <yandex_io/services/aliced/alice_config/alice_config.h>
#include <yandex_io/services/aliced/capabilities/alarm_capability/alarm_capability.h>
#include <yandex_io/services/aliced/capabilities/alice_capability/alice_capability.h>
#include <yandex_io/services/aliced/capabilities/audio_player_capability/audio_player_capability.h>
#include <yandex_io/services/aliced/capabilities/bluetooth_capability/bluetooth_capability.h>
#include <yandex_io/services/aliced/capabilities/file_player_capability/file_player_capability.h>
#include <yandex_io/services/aliced/capabilities/legacy_player_capability/legacy_player_capability.h>
#include <yandex_io/services/aliced/capabilities/mrforwarder_capability/mrforwarder_capability.h>
#include <yandex_io/services/aliced/capabilities/multiroom_capability/multiroom_capability.h>
#include <yandex_io/services/aliced/capabilities/tandem_capability/tandem_capability.h>
#include <yandex_io/services/aliced/capabilities/playback_control_capability/playback_control_capability.h>
#include <yandex_io/services/aliced/capabilities/screen_capability/screen_capability.h>
#include <yandex_io/services/aliced/device_state/alice_device_state.h>
#include <yandex_io/services/aliced/directive_processor/directive_processor.h>
#include <yandex_io/services/aliced/speechkit_facade/random_sound_logger/random_sound_logger.h>
#include <yandex_io/services/aliced/speechkit_facade/jingle/jingle_audio_client_player.h>
#include <yandex_io/services/aliced/uniproxy_pinger/uniproxy_pinger.h>

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/interfaces/clock_tower/i_clock_tower_provider.h>
#include <yandex_io/interfaces/device_state/i_device_state_provider.h>
#include <yandex_io/interfaces/glagol/i_glagol_cluster_provider.h>
#include <yandex_io/interfaces/multiroom/i_multiroom_provider.h>
#include <yandex_io/interfaces/stereo_pair/i_stereo_pair_provider.h>
#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/activity_tracker/activity_tracker.h>
#include <yandex_io/libs/activity_tracker/channel_activity.h>
#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/connection_stats_sender/connection_stats_sender.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/connections_state_holder.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/self_destroyer/self_destroyer.h>
#include <yandex_io/libs/voice_stats/voice_stats.h>
#include <yandex_io/protos/model_objects.pb.h>

#include <yandex_io/sdk/sdk_interface.h>
#include <yandex_io/sdk/audio_source/defines.h>
#include <yandex_io/sdk/audio_source/i_audio_source_client.h>
#include <yandex_io/sdk/private/device_context.h>

#include <yandex_io/capabilities/device_state/host/device_state_capability_host.h>

#include <alice/protos/endpoint/endpoint.pb.h>
#include <alice/megamind/protos/common/environment_state.pb.h>

#include <speechkit/AudioSource.h>
#include <speechkit/Recognition.h>
#include <speechkit/SpeechKit.h>
#include <speechkit/VinsResponse.h>
#include <speechkit/VoiceService.h>
#include <speechkit/VoiceServiceSettings.h>

#include <chrono>
#include <deque>
#include <map>
#include <memory>
#include <optional>
#include <string>
#include <thread>
#include <unordered_set>
#include <vector>

namespace quasar {
    class SpeechkitEndpoint
        : public YandexIO::IDirectiveProcessorListener,
          public SpeechKit::VoiceService::VoiceServiceListener,
          public std::enable_shared_from_this<SpeechkitEndpoint> {
        static const std::string GET_NEXT_REQUEST_FAILED_KEY;

    public:
        static const std::string SERVICE_NAME;

    public:
        SpeechkitEndpoint(std::shared_ptr<YandexIO::IDevice> device,
                          NAlice::TEndpoint::EEndpointType endpointType,
                          std::shared_ptr<YandexIO::SDKInterface> sdk,
                          std::shared_ptr<ipc::IIpcFactory> ipcFactory,
                          std::shared_ptr<quasar::IAuthProvider> authProvider,
                          std::shared_ptr<IClockTowerProvider> clockTowerProvider,
                          std::shared_ptr<IDeviceStateProvider> deviceStateProvider,
                          std::shared_ptr<IGlagolClusterProvider> glagolClusterProvider,
                          std::shared_ptr<IMultiroomProvider> multiroomProvider,
                          std::shared_ptr<IStereoPairProvider> stereoPairProvider,
                          std::shared_ptr<IUserConfigProvider> userConfigProvider,
                          SpeechKit::AudioPlayer::SharedPtr audioPlayer,
                          std::shared_ptr<AliceAudioSource> audioSource,
                          std::shared_ptr<YandexIO::IAudioSourceClient> audioSourceClient,
                          std::shared_ptr<VoiceStats> voiceStats,
                          std::shared_ptr<RandomSoundLogger> randomSoundLogger,
                          std::shared_ptr<SelfDestroyer> selfDestroyer,
                          std::shared_ptr<ICallbackQueue> callbackExecutor,
                          std::unique_ptr<quasar::IBackoffRetries> backoffer,
                          AliceConfig& aliceConfig,
                          std::shared_ptr<AliceDeviceState> aliceDeviceState);
        ~SpeechkitEndpoint();

        void start(std::shared_ptr<QuasarVoiceDialog> voiceDialog);
        void setVqeInfo(YandexIO::ChannelData::VqeInfo vqeInfo);

    private:
        void initConnectors();
        void initCapabilities();
        void initPreprocessors();

        void updateDialogSettings();
        void updateLocalVinsPreprocessor();
        void updateUniProxyPinger();

        void handleServiceReady(const std::string& serviceName);

        void startSpotting();
        void onDeviceContextVinsResponse(std::string jsonPayload);

        // SpeechKit::VoiceService::VoiceServiceListener implementation
        //
        void onPhraseSpotterBegin(SpeechKit::VoiceService::SharedPtr voiceDialog) override;
        void onPhraseSpotted(SpeechKit::VoiceService::SharedPtr voiceDialog, const std::string& phrase) override;
        void onPhraseSpotterError(SpeechKit::VoiceService::SharedPtr voiceDialog, const SpeechKit::Error& error) override;
        void onInterruptionPhraseSpotted(SpeechKit::VoiceService::SharedPtr voiceDialog, const std::string& phrase) override;
        void onCommandSpotterBegin(SpeechKit::VoiceService::SharedPtr voiceDialog) override;
        void onCommandPhraseSpotted(SpeechKit::VoiceService::SharedPtr voiceDialog, const std::string& phrase) override;
        void onCommandSpotterError(SpeechKit::VoiceService::SharedPtr voiceDialog, const SpeechKit::Error& error) override;
        void onRecognitionBegin(SpeechKit::VoiceService::SharedPtr voiceDialog, const std::string& requestId) override;
        void onRecognitionVoice(SpeechKit::VoiceService::SharedPtr /* voiceDialog */, const std::string& /*requestId*/, float /* voicePower */, bool /* hasSpeech */, bool /* hasMusic */) override {
        }
        void onRecognitionResults(SpeechKit::VoiceService::SharedPtr voiceDialog, const std::string& requestId, const SpeechKit::Recognition& recognition, bool endOfUtterance) override;
        void onRecognitionEnd(SpeechKit::VoiceService::SharedPtr voiceDialog, const std::string& requestId) override;
        void onRecognitionError(SpeechKit::VoiceService::SharedPtr voiceDialog, const std::string& requestId, const SpeechKit::Error& error) override;
        void onVinsRequestBegin(SpeechKit::VoiceService::SharedPtr voiceDialog, const std::string& requestId) override;
        void onVinsResponse(SpeechKit::VoiceService::SharedPtr voiceDialog,
                            const SpeechKit::VinsResponse& response,
                            SpeechKit::TTSDataProvider::SharedPtr ttsDataProvider) override;
        void onVinsError(SpeechKit::VoiceService::SharedPtr voiceDialog, const std::string& requestId, const SpeechKit::Error& error) override;
        void onConnectionStateChanged(SpeechKit::VoiceService::SharedPtr voiceDialog, bool isConnected) override;
        void onInvalidOAuthToken(SpeechKit::VoiceService::SharedPtr /* voiceService */) override;

        void onUniProxyDirective(SpeechKit::VoiceService::SharedPtr voiceDialog, const std::string& jsonHeader,
                                 const std::string& jsonPayload) override;

        void playSound(const std::string& wavName);
        void reportAllStartupSettings();

        // YandexIO::IDirectiveProcessorListener implementation
        //
        void onSequenceStateChanged() override;
        void onDialogChannelIsIdle() override;
        void onDirectiveHandled(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void onDirectiveStarted(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void onDirectiveCompleted(const std::shared_ptr<YandexIO::Directive>& directive, YandexIO::IDirectiveProcessorListener::Result result) override;

    private:
        bool hasInterfaced() const;
        void handleAudioClientConnect();
        void handleAudioClientDisconnect();
        void handleAudioClientMessage(const ipc::SharedMessage& message);
        void handleQuasarMessage(const ipc::SharedMessage& message, std::shared_ptr<ipc::IServer::IClientConnection> connection);
        void onGlagoldMessage(const ipc::SharedMessage& message);
        void handleInterfacedMessage(const ipc::SharedMessage& message);
        void handleMediadMessage(const ipc::SharedMessage& message);
        void handleIotState(const proto::IotState& iotState);

        void setReceivedConfig(const std::string& receivedConfig);
        void sendMetricaPhraseSpottedNoInternet(const SpeechKit::Error& error) const;
        void processAudiosenderConfig();
        void broadcastAppState(const quasar::proto::AppState& appState);

    private:
        static std::string convertIotResultCode(proto::IotDiscoveryResult::ResultCode resultCode);

        struct IotSemanticFrameParams {
            std::string purpose;
            std::string broadcastFieldName;
            std::optional<std::string> deviceType;
            std::optional<std::string> ssid;
            std::optional<std::string> password;
            std::optional<std::string> reason;
            std::optional<std::chrono::milliseconds> timeout;
        };
        static Json::Value buildIotSemanticFrame(const IotSemanticFrameParams& params);

        bool arePrerequisitesFulfilled() const;
        void checkServicesForNotifications();

        void startVoiceInteraction();
        ::SpeechKit::AudioPlayer::SharedPtr getDialogPlayer() const;

        void onSpottingStarted();
        void onLocation(const proto::Location& location);
        void onTimezone(const proto::Timezone& timezone);
        void onWifiList(const proto::WifiList& wifiList);
        void onMetricaUuidReceived(const std::string& uuid, std::chrono::milliseconds delay);
        void onStartDialogTimeoutExpired();

        void onDeviceStatePart(const yandex_io::proto::TDeviceStatePart& statePart);
        void onMediaDeviceIdentifier(const NAlice::TClientInfoProto::TMediaDeviceIdentifier& identifier);
        void broadcastEnvironmentDeviceInfo();
        void reportNavigationRequest(const proto::ControlRequest& controlRequest);
        const std::shared_ptr<YandexIO::DirectiveProcessor>& getDirectiveProcessor() const;

        // @deprecated
        // Remove method after https://st.yandex-team.ru/SK-5980
        void startAliceRequest(
            const proto::VinsServerAction& vinsServerAction,
            std::shared_ptr<YandexIO::IAliceRequestEvents> events);

    private:
        Lifetime lifetime_;
        std::shared_ptr<SelfDestroyer> selfDestroyer_;
        const std::shared_ptr<ICallbackQueue> asyncQueue_;
        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::shared_ptr<YandexIO::SDKInterface> sdk_;
        const std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        const std::shared_ptr<IAuthProvider> authProvider_;
        const std::shared_ptr<IClockTowerProvider> clockTowerProvider_;
        const std::shared_ptr<IDeviceStateProvider> deviceStateProvider_;
        const std::shared_ptr<IGlagolClusterProvider> glagolClusterProvider_;
        const std::shared_ptr<IMultiroomProvider> multiroomProvider_;
        const std::shared_ptr<IStereoPairProvider> stereoPairProvider_;
        const std::shared_ptr<IUserConfigProvider> userConfigProvider_;

        std::shared_ptr<ipc::IConnector> toMediad_;
        std::shared_ptr<ipc::IConnector> toSyncd_;
        std::shared_ptr<ipc::IConnector> toWifid_;
        std::shared_ptr<ipc::IConnector> toNetworkd_;
        std::shared_ptr<ipc::IConnector> toBrickd_;
        std::shared_ptr<ipc::IConnector> toAudioClientd_;
        std::shared_ptr<ipc::IConnector> toCalld_;
        std::shared_ptr<ipc::IConnector> toIot_;
        std::shared_ptr<ipc::IConnector> toDoNotDisturb_;
        std::shared_ptr<ipc::IConnector> toInterfaced_;
        std::shared_ptr<ipc::IConnector> toBugReport_;
        std::shared_ptr<ipc::IConnector> toNotificationd_;
        std::shared_ptr<ipc::IConnector> toGlagold_;
        std::shared_ptr<ipc::IConnector> toVideod_;
        std::shared_ptr<ipc::IServer> server_;

        bool dialogStarted_ = false;
        bool directiveProcessorStarted_ = false;
        bool singleDialogStarted_ = false;
        bool firstDialogStartTimerExpired_ = false;
        std::shared_ptr<QuasarVoiceDialog> voiceDialog_;
        SpeechKit::AudioPlayer::SharedPtr audioPlayer_;
        const JingleAudioClientPlayer::SharedPtr jingleCustomPlayer_;
        const std::shared_ptr<AliceAudioSource> audioSource_;
        const std::shared_ptr<YandexIO::IAudioSourceClient> audioSourceClient_;

        std::shared_ptr<VoiceStats> voiceStats_;
        std::unique_ptr<UniProxyPinger> uniProxyPinger_;
        std::shared_ptr<RandomSoundLogger> randomSoundLogger_;
        BrokenMicInfoLogger brokenMicInfoLogger_;
        std::optional<YandexIO::VinsResponse> pendingVinsResponse_;
        ConnectionStatsSender connectionStatsSender_;
        ConnectionsStateHolder connectionsStateHolder_;
        FeaturesConfig featuresConfig_;

        AliceConfig& aliceConfig_;
        const std::shared_ptr<AliceDeviceState> deviceState_;
        YandexIO::DeviceContext deviceContext_;
        YandexIO::ActivityTracker activityTracker_;
        AudioFocusDispatcher audioFocusDispatcher_;
        std::shared_ptr<AlarmCapability> alarmCapability_;
        std::shared_ptr<YandexIO::AliceCapability> aliceCapability_;
        std::shared_ptr<AudioPlayerCapability> audioPlayerCapability_;
        std::shared_ptr<MRForwarderCapability> mrForwarderCapability_;
        std::shared_ptr<MultiroomCapability> multiroomCapability_;
        std::shared_ptr<YandexIO::BluetoothCapability> bluetoothCapability_;
        std::shared_ptr<YandexIO::TandemCapability> tandemCapability_;
        std::shared_ptr<FilePlayerCapability> filePlayerCapability_;
        std::shared_ptr<YandexIO::ScreenCapability> screenCapability_;
        std::shared_ptr<NaviOldSpotterCapability> naviOldSpotterCapability_;
        std::shared_ptr<CommandSpotterCapability> commandSpotterCapability_;
        std::shared_ptr<ActivationSpotterCapability> activationSpotterCapability_;
        std::shared_ptr<LocalVinsPreprocessor> localVinsPreprocessor_;
        std::shared_ptr<YandexIO::PlaybackControlCapability> playbackCapability_;
        std::shared_ptr<YandexIO::DeviceController> deviceController_;
        std::shared_ptr<YandexIO::DeviceStateCapabilityHost> deviceStateCapability_;
        std::shared_ptr<YandexIO::LegacyPlayerCapability> legacyPlayerCapability_;

    public:
        std::function<void(const proto::QuasarMessage&)> onQuasarMessageReceivedCallback; // Testing purposes only!
    };
} // namespace quasar
