#pragma once

#include <yandex_io/libs/voice_stats/voice_stats.h>
#include <yandex_io/protos/model_objects.pb.h>
#include <yandex_io/sdk/audio_source/defines.h>
#include <yandex_io/sdk/audio_source/i_audio_source_client.h>

#include <speechkit/AudioSource.h>
#include <speechkit/SoundInfo.h>

#include <functional>
#include <list>
#include <memory>
#include <mutex>
#include <unordered_set>

namespace quasar {

    class AliceAudioSource
        : public SpeechKit::AudioSource,
          public YandexIO::IAudioSourceClient::Listener,
          public std::enable_shared_from_this<AliceAudioSource> {
    public:
        using OnVqeInfoChanged = std::function<void(YandexIO::ChannelData::VqeInfo)>;
        static std::shared_ptr<AliceAudioSource> create(OnVqeInfoChanged onVqeInfoChanged, std::shared_ptr<VoiceStats> voiceStats);

    public:
        /* SpeechKit::AudioSource */
        int getBufferCaptureTimeout() const override;
        const SpeechKit::SoundInfo& getSoundInfo() const override;
        void subscribe(AudioSourceListener::WeakPtr listener) override;
        void unsubscribe(AudioSourceListener::WeakPtr listener) override;

        /* YandexIO::AudioSourceClient::Listener interface */
        void onAudioData(const YandexIO::ChannelsData& data) override;

        static SpeechKit::CompositeSoundBuffer::SharedPtr createSpeechkitBuffer(
            const google::protobuf::RepeatedPtrField<quasar::proto::AudioInput>& audioInputs);

    private:
        explicit AliceAudioSource(OnVqeInfoChanged onVqeInfoChanged, std::shared_ptr<VoiceStats> voiceStats);

    private:
        YandexIO::ChannelData::VqeInfo vqeInfo_;
        const OnVqeInfoChanged onVqeInfoChanged_;
        std::mutex listenersMutex_;
        std::list<AudioSourceListener::WeakPtr> listeners_;
        std::shared_ptr<VoiceStats> voiceStats_;
    };

} // namespace quasar
