#pragma once

#include <yandex_io/libs/telemetry/telemetry.h>
#include <yandex_io/protos/model_objects.pb.h>

#include <speechkit/core/include/speechkit/SoundLogger.h>

#include <map>
#include <memory>
#include <string>
#include <unordered_map>
#include <vector>

namespace quasar {

    class BrokenMicInfoLogger
        : public SpeechKit::SoundLogger::ResultSink,
          public std::enable_shared_from_this<BrokenMicInfoLogger> {
    public:
        BrokenMicInfoLogger(std::shared_ptr<YandexIO::ITelemetry> telemetry);

        /* SpeechKit::SoundLogger::ResultSink */
        void onSuccess(const std::string& id, const std::vector<std::string>& messageIds) override;
        void onFail(const std::string& id, const std::string& error) override;

        void log(const proto::BrokenMicInfo& message);

    private:
        struct SendEntry {
            std::vector<double> rmsRatios_;
            bool firstSetup_;
        };

    private:
        static void fillCommonArgs(std::unordered_map<std::string, std::string>& args, const SendEntry& entry);

    private:
        std::shared_ptr<YandexIO::ITelemetry> telemetry_;
        std::map<std::string, SendEntry> idToEntry_;
    };

} // namespace quasar
