#pragma once

#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/protos/model_objects.pb.h>

#include <speechkit/AudioPlayer.h>

#include <list>
#include <memory>

namespace quasar {

    class JingleAudioClientPlayer: public SpeechKit::AudioPlayer, public std::enable_shared_from_this<JingleAudioClientPlayer> {
    public:
        using SharedPtr = std::shared_ptr<JingleAudioClientPlayer>;

        explicit JingleAudioClientPlayer(std::shared_ptr<ipc::IConnector> connector);
        ~JingleAudioClientPlayer();

        /* Audio Player API */
        void play() override;

        void pause() override;

        void cancel() override;

        void playData(SpeechKit::SoundBuffer::SharedPtr buffer) override;

        void setDataEnd() override;

        void setVolume(float gain) override;

        float getVolume() const override;

        void subscribe(AudioPlayerListener::WeakPtr listener) override;

        void unsubscribe(AudioPlayerListener::WeakPtr listener) override;

    public:
        // AudioClient api
        void onAudioClientEvent(const proto::AudioClientEvent& event);
        void handleAudioClientEvent(const proto::AudioClientEvent& event);
        void handlePlayingStart(int rate);
        void sendStreamData(const char* data, size_t size);

        // internal listeners api
        void removeExpired();
        void notifyListeners(std::function<void(AudioPlayerListener&)> /*func*/);

        bool playing_{false};
        int rate_;
        std::list<AudioPlayerListener::WeakPtr> listeners_;
        const proto::AudioPlayerDescriptor descriptor_;
        const std::shared_ptr<ipc::IConnector> connector_;
        NamedCallbackQueue worker_{"jingle_player"};
    };

} /* namespace quasar */
