#pragma once

#include <yandex_io/services/aliced/alice_config/alice_config.h>

#include <yandex_io/protos/model_objects.pb.h>

#include <speechkit/AudioPlayer.h>
#include <speechkit/PhraseSpotter.h>
#include <speechkit/PhraseSpotterSettings.h>
#include <speechkit/UniProxyClient.h>
#include <speechkit/UniProxyClientSettings.h>
#include <speechkit/VoiceService.h>
#include <speechkit/VoiceServiceSettings.h>

#include <memory>
#include <string>

namespace quasar {
    class QuasarVoiceDialog {
    public:
        using SharedPtr = std::shared_ptr<QuasarVoiceDialog>;

    public:
        virtual ~QuasarVoiceDialog() = default;

        virtual void update(const AliceConfig& config) = 0;
        virtual void setSettings(::SpeechKit::VoiceServiceSettings settings) = 0;
        virtual void setPlayer(::SpeechKit::AudioPlayer::SharedPtr player) = 0;
        virtual void setSynchronizeStatePayload(const std::string& synchronizeStatePayload) = 0;
        virtual void startVoiceInput(const SpeechKit::UniProxy::Header& header, const std::string& voiceInput, bool jingle) = 0;
        virtual void startMusicInput(const SpeechKit::UniProxy::Header& header, const std::string& musicInput, bool jingle) = 0;
        virtual void stopInput() = 0;
        virtual void startPhraseSpotter() = 0;
        virtual void startCommandSpotter(SpeechKit::PhraseSpotterSettings settings) = 0;
        virtual void stopCommandSpotter() = 0;
        virtual void cancel(bool silent) = 0;
        virtual void playCancelSound() = 0;
        virtual void prepare(const std::string& uuid, const std::string& yandexUid,
                             const std::string& timezone, const std::string& group, const std::string& subgroup) = 0;
        virtual void sendEvent(const SpeechKit::UniProxy::Header& header, const std::string& payload) = 0;
        virtual void startTextInput(const SpeechKit::UniProxy::Header& header, const std::string& payload) = 0;
        virtual void startInterruptionSpotter() = 0;
        virtual void stopInterruptionSpotter() = 0;
        virtual void updatePrevReqId(const std::string& requestId) = 0;

        virtual void onTtsStarted(const std::string& messageId) = 0;
        virtual void onTtsCompleted(const std::string& messageId) = 0;
        virtual void onTtsError(const SpeechKit::Error& error, const std::string& messageId) = 0;
    };

} // namespace quasar
