#pragma once

#include "alice_audio_source.h"
#include "quasar_voice_dialog.h"
#include "sk_persistent_storage.h"

#include <speechkit/AudioSource.h>
#include <speechkit/Logger.h>
#include <speechkit/SpeechKit.h>
#include <speechkit/UniProxy.h>
#include <speechkit/VoiceService.h>

#include <chrono>
#include <memory>
#include <optional>
#include <set>
#include <thread>

namespace quasar {
    class SkPlatformInfo;

    class MetricaEventLogger: public SpeechKit::EventLogger {
    public:
        MetricaEventLogger(std::shared_ptr<YandexIO::IDevice> device);

        void reportEvent(const std::string& eventName, const EventArgs& args) override;

    private:
        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::set<std::string> eventsToSkip_;
    };

    class SpeechKitLoggerGuard {
        std::string name_;

    public:
        SpeechKitLoggerGuard(const std::string& name, std::shared_ptr<SpeechKit::Logger> newLogger);
        ~SpeechKitLoggerGuard();

        SpeechKitLoggerGuard(const SpeechKitLoggerGuard&) = delete;
        SpeechKitLoggerGuard(SpeechKitLoggerGuard&&) = delete;
    };

    class QuasarVoiceDialogLinuxImpl: public QuasarVoiceDialog {
    public:
        QuasarVoiceDialogLinuxImpl(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<SpeechKit::VoiceService::VoiceServiceListener> listener,
            std::shared_ptr<AliceAudioSource> audioSource,
            SpeechKit::AudioPlayer::SharedPtr audioPlayer);

        void update(const AliceConfig& config) override;
        void setSettings(::SpeechKit::VoiceServiceSettings settings) override;
        void setPlayer(::SpeechKit::AudioPlayer::SharedPtr player) override;
        void setSynchronizeStatePayload(const std::string& synchronizeStatePayload) override;

        void startVoiceInput(const SpeechKit::UniProxy::Header& header, const std::string& voiceInput, bool jingle) override;
        void startMusicInput(const SpeechKit::UniProxy::Header& header, const std::string& musicInput, bool jingle) override;
        void stopInput() override;
        void startPhraseSpotter() override;
        void startCommandSpotter(SpeechKit::PhraseSpotterSettings settings) override;
        void stopCommandSpotter() override;
        void cancel(bool silent) override;
        void playCancelSound() override;
        void prepare(const std::string& uuid, const std::string& yandexUid,
                     const std::string& timezone, const std::string& group, const std::string& subgroup) override;
        void sendEvent(const SpeechKit::UniProxy::Header& header, const std::string& payload) override;
        void startTextInput(const SpeechKit::UniProxy::Header& header, const std::string& payload) override;
        void startInterruptionSpotter() override;
        void stopInterruptionSpotter() override;
        void updatePrevReqId(const std::string& requestId) override;

        void onTtsStarted(const std::string& messageId) override;
        void onTtsCompleted(const std::string& messageId) override;
        void onTtsError(const SpeechKit::Error& error, const std::string& messageId) override;

    private:
        void initSpeechKit();
        void initLogging();
        void setApiKey(const std::string& key);
        static void setUseDnsCache(bool useDnsCache);
        static void setLoggingSettings(std::chrono::milliseconds subthresholdRate, unsigned parallelSendings);
        void setLogLevel(std::optional<std::string> optLevel);

    private:
        std::shared_ptr<YandexIO::IDevice> device_;
        SpeechKitLoggerGuard loggerGuard_;

        SpeechKit::VoiceDialog::Earcons earcons_;
        std::shared_ptr<MetricaEventLogger> eventLogger_;

        std::shared_ptr<SpeechKit::PersistentStorage> persistentStorage_;
        std::shared_ptr<SkPlatformInfo> platformInfo_;

        SpeechKit::VoiceService::SharedPtr voiceDialog_;
        std::shared_ptr<AliceAudioSource> audioSource_;

        std::string defaultLogLevel_;
    };

} // namespace quasar
