#include "sk_persistent_storage.h"

#include <yandex_io/libs/base/persistent_file.h>
#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>

#include <fstream>
#include <sstream>

using namespace quasar;

SkPersistentStorage::SkPersistentStorage(std::string filepath)
    : filepath_{std::move(filepath)}
{
    auto file = std::ifstream(filepath_);
    if (file.is_open()) {
        std::ostringstream buffer;
        buffer << file.rdbuf();

        auto storage{tryParseJson(buffer.str())};
        if (storage.has_value()) {
            storage_ = std::move(*storage);
        }

        file.close();
    }
}

std::string SkPersistentStorage::getString(const std::string& name) const {
    std::lock_guard<std::mutex> guard{storageMutex_};
    return tryGetString(storage_, name, "");
}

void SkPersistentStorage::setString(const std::string& name, const std::string& value)
{
    std::lock_guard<std::mutex> guard{storageMutex_};
    storage_[name] = Json::Value(value);
    AtomicFile file{filepath_};
    file.write(jsonToString(storage_));
}
