#pragma once

#include <json/json.h>

#include <speechkit/PersistentStorage.h>

#include <mutex>
#include <string>

namespace quasar {

    class SkPersistentStorage: public ::SpeechKit::PersistentStorage {
    public:
        explicit SkPersistentStorage(std::string filepath);

        std::string getString(const std::string& name) const override;
        void setString(const std::string& name, const std::string& value) override;

    private:
        std::string filepath_;
        Json::Value storage_{Json::objectValue};

        mutable std::mutex storageMutex_;
    };

} // namespace quasar
