#include "sk_platform_info.h"

#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/json_utils/json_utils.h>

using namespace quasar;

SkPlatformInfo::SkPlatformInfo(std::shared_ptr<YandexIO::IDevice> device)
    : device_(std::move(device))
{
    auto spConfig = device_->configuration()->getServiceConfig("aliced");
    auto commonConfig = device_->configuration()->getServiceConfig("common");

    appId_ = getString(spConfig, "app_id");
    appVersion_ = getString(spConfig, "app_version");
    firmwareVersion_ = getString(commonConfig, "softwareVersion");
    oSVersion_ = getString(commonConfig, "os_version");
    appPlatform_ = getString(commonConfig, "os");
    deviceColor_ = device_->color();
    deviceModel_ = tryGetString(commonConfig, "deviceTypeForSpeechkit", "");
    deviceRevision_ = device_->platformRevision();
    if (deviceModel_.empty()) {
        deviceModel_ = getString(commonConfig, "deviceType");
    }
    deviceManufacturer_ = getString(commonConfig, "device_manufacturer");
}

void SkPlatformInfo::setTimezone(std::string timezone)
{
    olsonDbTimezoneName_ = std::move(timezone);
}

std::string SkPlatformInfo::getAppId() const {
    return appId_;
}

std::string SkPlatformInfo::getAppName() const {
    return appName_;
}

std::string SkPlatformInfo::getAppPlatform() const {
    return appPlatform_;
}

std::string SkPlatformInfo::getAppVersion() const {
    return appVersion_;
}

std::string SkPlatformInfo::getFirmwareVersion() const {
    return firmwareVersion_;
}

std::string SkPlatformInfo::getDeviceColor() const {
    return deviceColor_;
}

std::string SkPlatformInfo::getDeviceModel() const {
    return deviceModel_;
}

std::string SkPlatformInfo::getDeviceRevision() const {
    return deviceRevision_;
}

std::string SkPlatformInfo::getDeviceManufacturer() const {
    return deviceManufacturer_;
}

std::string SkPlatformInfo::getOSVersion() const {
    return oSVersion_;
}

std::string SkPlatformInfo::getAppDirectory() const {
    return appDirectory_;
}

std::string SkPlatformInfo::getOlsonDbTimezoneName() const {
    return olsonDbTimezoneName_;
}

::SpeechKit::PlatformInfo::BluetoothInfo SkPlatformInfo::getBluetoothInfo() const {
    return bluetoothInfo_;
}

std::vector<std::string> SkPlatformInfo::getSupportedFeatures() const {
    const auto jsonSupportedFeatures = device_->configuration()->getSupportedFeatures();
    std::vector<std::string> supportedFeatures;
    supportedFeatures.reserve(jsonSupportedFeatures.size());
    for (const auto& el : jsonSupportedFeatures) {
        if (el.isString()) {
            supportedFeatures.push_back(el.asString());
        }
    }
    return supportedFeatures;
}

std::string SkPlatformInfo::getQuasmodromGroup() const {
    return quasmodromGroup_;
}

std::string SkPlatformInfo::getQuasmodromSubgroup() const {
    return quasmodromSubgroup_;
}

void SkPlatformInfo::setQuasmodromGroups(std::string group, std::string subgroup)
{
    quasmodromGroup_ = std::move(group);
    quasmodromSubgroup_ = std::move(subgroup);
}
