#pragma once

#include <yandex_io/libs/device/device.h>

#include <speechkit/core/include/speechkit/PlatformInfo.h>

#include <memory>
#include <string>
#include <vector>

namespace quasar {

    class SkPlatformInfo: public ::SpeechKit::PlatformInfo {
    public:
        explicit SkPlatformInfo(std::shared_ptr<YandexIO::IDevice> device);

        SkPlatformInfo() = delete;
        SkPlatformInfo(const SkPlatformInfo&) = delete;
        SkPlatformInfo& operator=(const SkPlatformInfo&) = delete;

        void setTimezone(std::string timezone);
        void setQuasmodromGroups(std::string group, std::string subgroup);

        std::string getAppId() const override;
        std::string getAppName() const override;
        std::string getAppPlatform() const override;
        std::string getAppVersion() const override;
        std::string getFirmwareVersion() const override;
        std::string getDeviceColor() const override;
        std::string getDeviceModel() const override;
        std::string getDeviceRevision() const override;
        std::string getDeviceManufacturer() const override;
        std::string getOSVersion() const override;
        std::string getAppDirectory() const override;
        std::string getOlsonDbTimezoneName() const override;
        std::vector<std::string> getSupportedFeatures() const override;
        BluetoothInfo getBluetoothInfo() const override;
        std::string getQuasmodromGroup() const override;
        std::string getQuasmodromSubgroup() const override;

    private:
        std::shared_ptr<YandexIO::IDevice> device_;

        std::string appId_;
        std::string appName_;
        std::string appPlatform_;
        std::string appVersion_;
        std::string firmwareVersion_;
        std::string deviceColor_;
        std::string deviceModel_;
        std::string deviceRevision_;
        std::string deviceManufacturer_;
        std::string oSVersion_;
        std::string appDirectory_;
        std::string olsonDbTimezoneName_;
        BluetoothInfo bluetoothInfo_;
        std::string quasmodromGroup_;
        std::string quasmodromSubgroup_;
    };

} // namespace quasar
