#pragma once

#include <yandex_io/libs/http_client/http_client.h>

#include <chrono>
#include <cstdint>
#include <string>

namespace quasar {

    class HttpPinger {
    public:
        using RetryCalculator = HttpClient::CalcRetryDelayFunction;

        struct Settings {
            std::string name;
            std::chrono::milliseconds timeout{0};
            std::uint32_t retriesCount{0};
            RetryCalculator retryCalculator;
        };

        struct PingRequest {
            std::string url;
            std::string data;
        };

        struct PingResult {
            std::chrono::milliseconds latency{0};
            std::uint32_t responseCode{0};
            std::uint32_t retries{0};
        };

    public:
        explicit HttpPinger(Settings settings, std::shared_ptr<YandexIO::IDevice> device);

        PingResult ping(const PingRequest& request);
        const std::optional<PingResult>& getLastResult() const;

    private:
        HttpClient::CalcRetryDelayFunction makeRetryCalculator(RetryCalculator retryCalculator);

    private:
        HttpClient client_;
        std::optional<PingResult> result_;
    };

} // namespace quasar
