#pragma once

#include "http_pinger.h"

#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/device/i_device.h>

#include <json/value.h>

#include <chrono>
#include <cstdint>
#include <optional>
#include <random>
#include <string>
#include <vector>

namespace quasar {

    class UniProxyPinger {
    public:
        struct Settings {
            std::vector<std::string> randomUrls;
            std::string url;
            std::chrono::milliseconds interval{60000};
            std::chrono::milliseconds timeout{2000};
            std::uint32_t parallelPings{0};
            std::uint32_t payloadBytes{0};
            std::uint32_t retriesCount{0};

            bool operator==(const Settings&) const = default;
            bool operator!=(const Settings&) const = default;
        };

        static std::optional<Settings> parseSettings(const Json::Value& config);

    public:
        UniProxyPinger(Settings settings, std::shared_ptr<::YandexIO::IDevice> device);
        ~UniProxyPinger();

        const Settings& getSettings() const;

    private:
        void schedulePing();
        void ping();

        std::unique_ptr<HttpPinger> createPinger(std::string name) const;
        HttpPinger::PingRequest createRequest(std::string url) const;

        std::string generatePayload(std::uint32_t payloadBytes) const;

        std::string getRandomUrl() const;
        bool urlPresents() const;

    private:
        const std::shared_ptr<::YandexIO::IDevice> device_;

        Lifetime lifetime_;
        NamedCallbackQueue asyncQueue_;

        mutable std::mt19937 randomGenerator_;

        const Settings settings_;
        const std::string payload_;
    };

} // namespace quasar
