#include "auth_service.h"

#include <memory>

using namespace quasar;

AuthService::AuthService(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory)
    : device_(device)
    , ipcFactory_(std::move(ipcFactory))
{
}

std::string AuthService::getServiceName() const {
    return AuthEndpoint::SERVICE_NAME;
}

void AuthService::start() {
    authEndpointPtr_ = std::make_unique<AuthEndpoint>(device_, ipcFactory_);
}
