#pragma once
#include "auth_endpoint.h"

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/telemetry/telemetry.h>

namespace quasar {
    class AuthService: public QuasarService {
    public:
        AuthService(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory);

        std::string getServiceName() const override;

    private:
        void start() override;

        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::unique_ptr<AuthEndpoint> authEndpointPtr_;
    };

} // namespace quasar
