#pragma once

#include "gatt_value_format.h"
#include "quasar_gatt_characteristic.h"

#include <yandex_io/interfaces/device_state/i_device_state_provider.h>
#include <yandex_io/libs/bluetooth/bluetooth_le.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/threading/periodic_executor.h>
#include <yandex_io/protos/model_objects.pb.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <set>
#include <vector>

namespace quasar {

    class BleEndpoint {
    public:
        explicit BleEndpoint(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IDeviceStateProvider> deviceStateProvider,
            std::shared_ptr<BluetoothLE> ble);
        ~BleEndpoint();

        int port() const;

        static const std::string SERVICE_NAME;

    private:
        static std::set<gatt_permission::GattPermission> getCharacteristicPermissions(const Json::Value& characteristic);

        void initConfigurationService(const std::shared_ptr<IGattService>& service, const Json::Value& characteristicsConfig);

        void switchBleAdvertising(bool enabled, bool setupInProgress);

        void sendStatusToClient(proto::SetupStatusMessage::SetupStatus status);

        void processQuasarMessage(const ipc::SharedMessage& message);

        void onConnectMessageReceived(std::vector<uint8_t> data);

    private:
        Lifetime lifetime_;
        std::shared_ptr<YandexIO::IDevice> device_;

        bool enabled_;
        bool updateInProgress_ = false;
        bool setupInProgress_ = false;

        std::shared_ptr<BluetoothLE> bleImpl_;

        std::shared_ptr<ipc::IConnector> setupdConnector_;
        std::shared_ptr<ipc::IConnector> wifidConnector_;
        std::shared_ptr<ipc::IServer> server_;

        std::unordered_map<std::string, std::shared_ptr<QuasarGattCharacteristic>> characteristics_;
    };

} // namespace quasar
