#include "ble_service.h"

#include <yandex_io/libs/bluetooth/bluetooth_le.h>

using namespace quasar;

BleService::BleService(
    std::shared_ptr<YandexIO::IDevice> device,
    std::shared_ptr<ipc::IIpcFactory> ipcFactory,
    std::shared_ptr<IDeviceStateProvider> deviceStateProvider)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
    , deviceStateProvider_(std::move(deviceStateProvider))
{
}

void BleService::start()
{
    if (device_->configuration()->getFullConfig().isMember(BleEndpoint::SERVICE_NAME)) {
        std::shared_ptr<BluetoothLE> ble = device_->hal()->createBluetoothLE();
        if (ble) {
            bleEndpoint_ = std::make_unique<BleEndpoint>(device_, ipcFactory_, deviceStateProvider_, ble);
        }
    }
}

std::string BleService::getServiceName() const {
    return BleEndpoint::SERVICE_NAME;
}
