#pragma once

#include "ble_endpoint.h"

#include <yandex_io/interfaces/device_state/i_device_state_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

namespace quasar {

    class BleService: public QuasarService {
    public:
        explicit BleService(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IDeviceStateProvider> deviceStateProvider);

        std::string getServiceName() const override;

    private:
        void start() override;

        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::shared_ptr<IDeviceStateProvider> deviceStateProvider_;
        std::unique_ptr<BleEndpoint> bleEndpoint_;
    };

} // namespace quasar
